/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.flink.ml.builder.GraphNode;
import org.apache.flink.ml.builder.TableId;
import org.apache.flink.table.api.Table;
import org.apache.flink.util.Preconditions;

class GraphExecutionHelper {
    private final Map<TableId, List<GraphNode>> consumerNodes = new HashMap<TableId, List<GraphNode>>();
    private final Map<TableId, Table> constructedTables = new HashMap<TableId, Table>();
    private final Map<GraphNode, Integer> numUnConstructedInputTables = new HashMap<GraphNode, Integer>();
    private final Deque<GraphNode> unFetchedReadyNodes = new LinkedList<GraphNode>();

    public GraphExecutionHelper(List<GraphNode> nodes) {
        for (GraphNode node : nodes) {
            ArrayList<TableId> inputs = new ArrayList<TableId>();
            inputs.addAll(Arrays.asList(node.algoOpInputIds));
            if (node.estimatorInputIds != null) {
                inputs.addAll(Arrays.asList(node.estimatorInputIds));
            }
            if (node.inputModelDataIds != null) {
                inputs.addAll(Arrays.asList(node.inputModelDataIds));
            }
            this.numUnConstructedInputTables.put(node, inputs.size());
            for (TableId tableId : inputs) {
                this.consumerNodes.putIfAbsent(tableId, new ArrayList());
                this.consumerNodes.get(tableId).add(node);
            }
        }
    }

    public void setTables(TableId[] tableIds, Table[] tables) {
        Preconditions.checkArgument((tableIds.length >= tables.length ? 1 : 0) != 0, (String)"the length of tablesIds %s is less than the length of tables %s", (Object[])new Object[]{tableIds.length, tables.length});
        for (int i = 0; i < tables.length; ++i) {
            this.setTable(tableIds[i], tables[i]);
        }
    }

    private void setTable(TableId tableId, Table table) {
        Preconditions.checkArgument((!this.constructedTables.containsKey(tableId) ? 1 : 0) != 0, (String)"the table with id=%s has already been constructed", (Object[])new Object[]{tableId.toString()});
        this.constructedTables.put(tableId, table);
        for (GraphNode node : (List)this.consumerNodes.getOrDefault(tableId, new ArrayList())) {
            int prevNum = this.numUnConstructedInputTables.get(node);
            if (prevNum == 1) {
                this.unFetchedReadyNodes.addLast(node);
                this.numUnConstructedInputTables.remove(node);
                continue;
            }
            this.numUnConstructedInputTables.put(node, prevNum - 1);
        }
    }

    public Table[] getTables(TableId[] tableIds) {
        Table[] tables = new Table[tableIds.length];
        for (int i = 0; i < tableIds.length; ++i) {
            tables[i] = this.getTable(tableIds[i]);
        }
        return tables;
    }

    private Table getTable(TableId tableId) {
        Preconditions.checkArgument((boolean)this.constructedTables.containsKey(tableId), (String)"the table with id=%s has not been constructed yet", (Object[])new Object[]{tableId.toString()});
        return this.constructedTables.get(tableId);
    }

    public GraphNode pollNextReadyNode() {
        if (this.unFetchedReadyNodes.isEmpty() && !this.numUnConstructedInputTables.isEmpty()) {
            throw new RuntimeException("there exists node whose input can not be constructed");
        }
        return this.unFetchedReadyNodes.pollFirst();
    }
}

