/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.datastream.sort;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

final class BytesKeyNormalizationUtil {
    static <IN> void putNormalizedKey(Tuple2<byte[], StreamRecord<IN>> record, int dataLength, MemorySegment target, int offset, int numBytes) {
        byte[] data = (byte[])record.f0;
        if (dataLength >= numBytes) {
            BytesKeyNormalizationUtil.putBytesArray(target, offset, numBytes, data);
        } else {
            BytesKeyNormalizationUtil.putBytesArray(target, offset, dataLength, data);
            int lastOffset = offset + numBytes;
            offset += dataLength;
            long valueOfTimestamp = ((StreamRecord)record.f1).asRecord().getTimestamp() - Long.MIN_VALUE;
            if (dataLength + 8 <= numBytes) {
                target.putLong(offset, valueOfTimestamp);
                offset += 8;
                while (offset < lastOffset) {
                    target.put(offset++, (byte)0);
                }
            } else {
                int i = 0;
                while (offset < lastOffset) {
                    target.put(offset, (byte)(valueOfTimestamp >>> (7 - i << 3)));
                    ++offset;
                    ++i;
                }
            }
        }
    }

    private static void putBytesArray(MemorySegment target, int offset, int numBytes, byte[] data) {
        for (int i = 0; i < numBytes; ++i) {
            int highByte = data[i] & 0xFF;
            target.put(offset + i, (byte)(highByte += 128));
        }
    }

    private BytesKeyNormalizationUtil() {
    }
}

