/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hbase;

import org.apache.hadoop.hbase.util.VersionInfo;
import org.slf4j.Logger;

class HBaseVersionCheck {
    HBaseVersionCheck() {
    }

    private static int getMajorVersion(String version) throws NumberFormatException {
        return Integer.parseInt(version.split("\\.")[0]);
    }

    static boolean hasVersionLessThan2(Logger logger) {
        String version = VersionInfo.getVersion();
        try {
            if (HBaseVersionCheck.getMajorVersion(version) < 2) {
                return true;
            }
        }
        catch (NumberFormatException ex) {
            logger.error(ex.getMessage());
        }
        logger.error("Invalid HBase version:" + version);
        return false;
    }
}

