/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.solr.morphline;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.conf.LogPrivacyUtil;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.source.http.HTTPSourceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobHandler
implements HTTPSourceHandler {
    private int maxBlobLength = 100000000;
    public static final String MAX_BLOB_LENGTH_KEY = "maxBlobLength";
    public static final int MAX_BLOB_LENGTH_DEFAULT = 100000000;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final Logger LOGGER = LoggerFactory.getLogger(BlobHandler.class);

    public void configure(Context context) {
        this.maxBlobLength = context.getInteger(MAX_BLOB_LENGTH_KEY, Integer.valueOf(100000000));
        if (this.maxBlobLength <= 0) {
            throw new ConfigurationException("Configuration parameter maxBlobLength must be greater than zero: " + this.maxBlobLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Event> getEvents(HttpServletRequest request) throws Exception {
        Map<String, String> headers = this.getHeaders(request);
        try (ServletInputStream in = request.getInputStream();){
            ByteArrayOutputStream blob = null;
            byte[] buf = new byte[Math.min(this.maxBlobLength, 8192)];
            int blobLength = 0;
            int n = 0;
            while ((n = in.read(buf, 0, Math.min(buf.length, this.maxBlobLength - blobLength))) != -1) {
                if (blob == null) {
                    blob = new ByteArrayOutputStream(n);
                }
                blob.write(buf, 0, n);
                if ((blobLength += n) < this.maxBlobLength) continue;
                LOGGER.warn("Request length exceeds maxBlobLength ({}), truncating BLOB event!", (Object)this.maxBlobLength);
                break;
            }
            byte[] array = blob != null ? blob.toByteArray() : new byte[]{};
            Event event = EventBuilder.withBody((byte[])array, headers);
            if (LOGGER.isDebugEnabled() && LogPrivacyUtil.allowLogRawData()) {
                LOGGER.debug("blobEvent: {}", (Object)event);
            }
            List<Event> list = Collections.singletonList(event);
            return list;
        }
    }

    private Map<String, String> getHeaders(HttpServletRequest request) {
        String name;
        Enumeration iter;
        if (LOGGER.isDebugEnabled() && LogPrivacyUtil.allowLogRawData()) {
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            iter = request.getHeaderNames();
            while (iter.hasMoreElements()) {
                name = (String)iter.nextElement();
                requestHeaders.put(name, request.getHeader(name));
            }
            LOGGER.debug("requestHeaders: {}", requestHeaders);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (request.getContentType() != null) {
            headers.put("Content-Type", request.getContentType());
        }
        iter = request.getParameterNames();
        while (iter.hasMoreElements()) {
            name = (String)iter.nextElement();
            headers.put(name, request.getParameter(name));
        }
        return headers;
    }
}

