/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async.auth;

import java.util.Date;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.zookeeper.Shell;
import org.hbase.async.Config;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Login {
    private static final Logger LOG = LoggerFactory.getLogger(Login.class);
    private static final float TICKET_RENEW_WINDOW = 0.8f;
    private static final float TICKET_RENEW_JITTER = 0.05f;
    static final long MIN_TIME_BEFORE_RELOGIN = 60000L;
    public static final String LOGIN_CONTEXT_NAME_KEY = "hbase.sasl.clientconfig";
    private static Random random = new Random(System.currentTimeMillis());
    private static Login current_login;
    private final Config config;
    private final HashedWheelTimer timer;
    private final CallbackHandler callback_handler;
    private final String login_context_name;
    private final Subject subject;
    private final boolean is_kerberos_ticket;
    private LoginContext login_context;
    private boolean using_ticket_cache;
    private String principal;

    public static synchronized void initUserIfNeeded(Config config, HashedWheelTimer timer, String login_context_name, CallbackHandler callback_handler) throws LoginException {
        if (current_login == null) {
            current_login = new Login(config, timer, login_context_name, callback_handler);
            LOG.info("Initialized kerberos login context");
        } else {
            LOG.debug("Already logged in");
        }
    }

    static Login getCurrentLogin() {
        return current_login;
    }

    Login(Config config, HashedWheelTimer timer, String login_context_name, CallbackHandler callback_handler) throws LoginException {
        AppConfigurationEntry[] entries;
        this.config = config;
        this.timer = timer;
        this.login_context_name = login_context_name;
        this.callback_handler = callback_handler;
        this.login_context = this.login(login_context_name);
        this.subject = this.login_context.getSubject();
        this.is_kerberos_ticket = !this.subject.getPrivateCredentials(KerberosTicket.class).isEmpty();
        AppConfigurationEntry[] arr$ = entries = Configuration.getConfiguration().getAppConfigurationEntry(login_context_name);
        int len$ = arr$.length;
        int i$ = 0;
        if (i$ < len$) {
            String val;
            AppConfigurationEntry entry = arr$[i$];
            if (entry.getOptions().get("useTicketCache") != null && (val = (String)entry.getOptions().get("useTicketCache")).toLowerCase().equals("true")) {
                this.using_ticket_cache = true;
            }
            if (entry.getOptions().get("keyTab") != null) {
                // empty if block
            }
            if (entry.getOptions().get("principal") != null) {
                this.principal = (String)entry.getOptions().get("principal");
            }
        }
        if (!this.is_kerberos_ticket) {
            return;
        }
        long delay = this.getRefreshDelay(this.getTGT());
        timer.newTimeout((TimerTask)new TicketRenewalTask(), delay, TimeUnit.MILLISECONDS);
        LOG.info("Scheduled ticket renewal in " + delay + " ms");
    }

    public Subject getSubject() {
        return this.subject;
    }

    private synchronized LoginContext login(String login_context_name) throws LoginException {
        if (login_context_name == null || login_context_name.isEmpty()) {
            throw new LoginException("Login context name (JAAS file section header) was null or empty. Please check your java.security.login.auth.config (=" + System.getProperty("java.security.auth.login.config") + ") and your " + LOGIN_CONTEXT_NAME_KEY + "(=" + login_context_name + ")");
        }
        LOG.debug("Constructing login context with context: " + login_context_name);
        LoginContext login_context = new LoginContext(login_context_name, this.callback_handler);
        login_context.login();
        LOG.info("Successfully logged in.");
        return login_context;
    }

    private long getRefreshDelay(KerberosTicket tgt) {
        long now = System.currentTimeMillis();
        long next_refresh = 60000L;
        if (tgt == null) {
            LOG.warn("No TGT found: will try again at " + new Date(next_refresh));
            return next_refresh;
        }
        long start = tgt.getStartTime().getTime();
        long expires = tgt.getEndTime().getTime();
        LOG.info("TGT valid starting at:        " + tgt.getStartTime().toString());
        LOG.info("TGT expires:                  " + tgt.getEndTime().toString());
        next_refresh = (long)((double)(expires - start) * ((double)0.8f + (double)0.05f * random.nextDouble()));
        if (this.using_ticket_cache && tgt.getEndTime().equals(tgt.getRenewTill())) {
            LOG.error("The TGT cannot be renewed beyond the next expiration date: " + new Date(expires) + ". This process will not be able to " + "authenticate new SASL connections after that time. Ask " + "your system administrator to either increase the 'renew " + "until' time by doing : 'modprinc -maxrenewlife " + this.principal + "' within kadmin, or instead, to generate a " + "keytab for " + this.principal + ". Because the TGT's expiration " + "cannot be further extended by refreshing, exiting refresh " + "thread now.");
            return 60000L;
        }
        if (now + next_refresh > expires || now + 60000L > expires) {
            LOG.info("Refreshing now because expiration " + new Date(expires) + " is before next scheduled refresh time " + new Date(now + next_refresh) + " or we are within " + 60000L + "ms of expiring.");
            next_refresh = 0L;
        } else {
            if (now + next_refresh < now + 60000L) {
                Date until = new Date(now + next_refresh);
                Date new_until = new Date(now + 60000L);
                LOG.warn("TGT refresh thread time adjusted from : " + until + " to : " + new_until + " since " + "the former is sooner than the minimum refresh interval (" + 60L + " seconds) from now.");
            }
            next_refresh = Math.max(next_refresh, 60000L);
        }
        if (now + next_refresh > expires) {
            LOG.error("Next refresh: " + new Date(now + next_refresh) + " is later than expiration " + new Date(expires) + ". This may indicate a clock skew problem. " + "Check that this host and the KDC's hosts' clocks are in sync.");
            next_refresh = 60000L;
        }
        return next_refresh;
    }

    private synchronized KerberosTicket getTGT() {
        Set<KerberosTicket> tickets = this.subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            KerberosPrincipal server = ticket.getServer();
            if (!server.getName().equals("krbtgt/" + server.getRealm() + "@" + server.getRealm())) continue;
            LOG.debug("Found tgt " + ticket + ".");
            return ticket;
        }
        return null;
    }

    private void refreshTicketCache() {
        String cmd = "/usr/bin/kinit";
        if (this.config.hasProperty("asynchbase.security.auth.kinit")) {
            cmd = this.config.getString("asynchbase.security.auth.kinit");
        }
        String args = "-R";
        try {
            LOG.info("Executing kinit command: " + cmd + " " + "-R");
            Shell.execCommand((String[])new String[]{cmd, "-R"});
        }
        catch (Exception e) {
            throw new RuntimeException("Could not renew TGT due to problem running shell command: '" + cmd + " " + "-R" + "';", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reLogin() throws LoginException {
        if (!this.is_kerberos_ticket) {
            return;
        }
        if (this.login_context == null) {
            throw new LoginException("Login must be done first");
        }
        LOG.info("Initiating logout for " + this.principal);
        Class<Login> clazz = Login.class;
        synchronized (Login.class) {
            this.login_context.logout();
            this.login_context = new LoginContext(this.login_context_name, this.subject);
            LOG.info("Initiating re-login for " + this.principal);
            this.login_context.login();
            LOG.info("Relogin was successful for " + this.principal);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    class TicketRenewalTask
    implements TimerTask {
        TicketRenewalTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Timeout timeout) {
            long next_refresh = 60000L;
            try {
                if (Login.this.using_ticket_cache) {
                    Login.this.refreshTicketCache();
                }
                Login.this.reLogin();
                next_refresh = Login.this.getRefreshDelay(Login.this.getTGT());
            }
            catch (LoginException e) {
                LOG.error("Failed to renew ticket", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error("Failed to renew ticket", (Throwable)e);
            }
            finally {
                LOG.debug("Scheduling next next login attempt in " + next_refresh + " ms");
                Login.this.timer.newTimeout((TimerTask)this, next_refresh, TimeUnit.MILLISECONDS);
            }
        }
    }
}

