/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.configfilter;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Map;
import java.util.Scanner;
import org.apache.flume.configfilter.AbstractConfigFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalProcessConfigFilter
extends AbstractConfigFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalProcessConfigFilter.class);
    private static final String COMMAND_KEY = "command";
    private static final String CHARSET_KEY = "charset";
    private static final String CHARSET_DEFAULT = "UTF-8";
    Charset charset;
    private String command;

    public String filter(String key) {
        try {
            return this.execCommand(key);
        }
        catch (IOException | IllegalStateException | InterruptedException ex) {
            LOGGER.error("Error while reading value for key {}: ", (Object)key, (Object)ex);
            return null;
        }
    }

    public void initializeWithConfiguration(Map<String, String> configuration) {
        String charsetName = configuration.getOrDefault(CHARSET_KEY, CHARSET_DEFAULT);
        try {
            this.charset = Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException ex) {
            throw new RuntimeException("Unsupported charset: " + charsetName, ex);
        }
        this.command = configuration.get(COMMAND_KEY);
        if (this.command == null) {
            throw new IllegalArgumentException("command must be set for ExternalProcessConfigFilter");
        }
    }

    private String execCommand(String key) throws IOException, InterruptedException {
        String[] split = this.command.split("\\s+");
        int newLength = split.length + 1;
        String[] commandParts = Arrays.copyOf(split, newLength);
        commandParts[newLength - 1] = key;
        Process p = Runtime.getRuntime().exec(commandParts);
        p.waitFor();
        if (p.exitValue() != 0) {
            String stderr;
            try {
                stderr = this.getResultFromStream(p.getErrorStream());
            }
            catch (Throwable t) {
                stderr = null;
            }
            throw new IllegalStateException(String.format("Process (%s) exited with non-zero (%s) status code. Sterr: %s", this.command, p.exitValue(), stderr));
        }
        return this.getResultFromStream(p.getInputStream());
    }

    private String getResultFromStream(InputStream inputStream) {
        try (Scanner scanner = new Scanner(inputStream, this.charset.name());){
            String result = null;
            if (scanner.hasNextLine()) {
                result = scanner.nextLine();
                if (scanner.hasNextLine()) {
                    LOGGER.warn("External process has more than one line of output. Only the first line is used.");
                }
            } else {
                LOGGER.warn("External process has not produced any output.");
            }
            String string = result;
            return string;
        }
    }
}

