/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.configfilter;

import java.io.IOException;
import java.util.Map;
import org.apache.flume.configfilter.AbstractConfigFilter;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopCredentialStoreConfigFilter
extends AbstractConfigFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopCredentialStoreConfigFilter.class);
    static final String PASSWORD_FILE_CONFIG_KEY = "credstore.java-keystore-provider.password-file";
    static final String CREDENTIAL_PROVIDER_PATH = "credential.provider.path";
    static final String HADOOP_SECURITY = "hadoop.security.";
    private Configuration hadoopConfiguration;

    public void initializeWithConfiguration(Map<String, String> configuration) {
        LOGGER.debug("Initializing hadoop credential store.");
        this.hadoopConfiguration = new Configuration();
        this.hadoopConfiguration.set("hadoop.security.credential.provider.path", configuration.get(CREDENTIAL_PROVIDER_PATH));
        String passwordFile = configuration.get(PASSWORD_FILE_CONFIG_KEY);
        if (passwordFile != null && !passwordFile.isEmpty()) {
            this.checkPasswordFile(passwordFile);
            this.hadoopConfiguration.set("hadoop.security.credstore.java-keystore-provider.password-file", passwordFile);
        }
    }

    private void checkPasswordFile(String passwordFile) {
        if (Thread.currentThread().getContextClassLoader().getResource(passwordFile) == null) {
            LOGGER.error("The java keystore provider password file has to be on the classpath. The password file provided in the configuration cannot be found and will not be used");
        }
    }

    public String filter(String key) {
        char[] result = null;
        try {
            result = this.hadoopConfiguration.getPassword(key);
        }
        catch (IOException e) {
            LOGGER.error("Error while reading value for key {}: ", (Object)key, (Object)e);
        }
        return result == null ? null : new String(result);
    }
}

