/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hbase2;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.sink.hbase2.HBase2EventSerializer;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;

public class RegexHBase2EventSerializer
implements HBase2EventSerializer {
    public static final String REGEX_CONFIG = "regex";
    public static final String REGEX_DEFAULT = "(.*)";
    public static final String IGNORE_CASE_CONFIG = "regexIgnoreCase";
    public static final boolean IGNORE_CASE_DEFAULT = false;
    public static final String COL_NAME_CONFIG = "colNames";
    public static final String COLUMN_NAME_DEFAULT = "payload";
    public static final String ROW_KEY_INDEX_CONFIG = "rowKeyIndex";
    public static final String ROW_KEY_NAME = "ROW_KEY";
    public static final String DEPOSIT_HEADERS_CONFIG = "depositHeaders";
    public static final boolean DEPOSIT_HEADERS_DEFAULT = false;
    public static final String CHARSET_CONFIG = "charset";
    public static final String CHARSET_DEFAULT = "UTF-8";
    protected static final AtomicInteger nonce = new AtomicInteger(0);
    protected static final String randomKey = RandomStringUtils.randomAlphanumeric((int)10);
    protected byte[] cf;
    private byte[] payload;
    private final List<byte[]> colNames = Lists.newArrayList();
    private Map<String, String> headers;
    private boolean depositHeaders;
    private Pattern inputPattern;
    private Charset charset;
    private int rowKeyIndex;

    public void configure(Context context) {
        String[] columnNames;
        String regex = context.getString(REGEX_CONFIG, REGEX_DEFAULT);
        boolean regexIgnoreCase = context.getBoolean(IGNORE_CASE_CONFIG, Boolean.valueOf(false));
        this.depositHeaders = context.getBoolean(DEPOSIT_HEADERS_CONFIG, Boolean.valueOf(false));
        this.inputPattern = Pattern.compile(regex, 32 + (regexIgnoreCase ? 2 : 0));
        this.charset = Charset.forName(context.getString(CHARSET_CONFIG, CHARSET_DEFAULT));
        String colNameStr = context.getString(COL_NAME_CONFIG, COLUMN_NAME_DEFAULT);
        for (String s : columnNames = colNameStr.split(",")) {
            this.colNames.add(s.getBytes(this.charset));
        }
        this.rowKeyIndex = context.getInteger(ROW_KEY_INDEX_CONFIG, Integer.valueOf(-1));
        if (this.rowKeyIndex >= 0) {
            if (this.rowKeyIndex >= columnNames.length) {
                throw new IllegalArgumentException("rowKeyIndex must be less than num columns " + columnNames.length);
            }
            if (!ROW_KEY_NAME.equalsIgnoreCase(columnNames[this.rowKeyIndex])) {
                throw new IllegalArgumentException("Column at " + this.rowKeyIndex + " must be " + ROW_KEY_NAME + " and is " + columnNames[this.rowKeyIndex]);
            }
        }
    }

    public void configure(ComponentConfiguration conf) {
    }

    @Override
    public void initialize(Event event, byte[] columnFamily) {
        this.headers = event.getHeaders();
        this.payload = event.getBody();
        this.cf = columnFamily;
    }

    protected byte[] getRowKey(Calendar cal) {
        String rowKey = String.format("%s-%s-%s", cal.getTimeInMillis(), randomKey, nonce.getAndIncrement());
        return rowKey.getBytes(this.charset);
    }

    protected byte[] getRowKey() {
        return this.getRowKey(Calendar.getInstance());
    }

    @Override
    public List<Row> getActions() throws FlumeException {
        ArrayList actions = Lists.newArrayList();
        Matcher m = this.inputPattern.matcher(new String(this.payload, this.charset));
        if (!m.matches()) {
            return Lists.newArrayList();
        }
        if (m.groupCount() != this.colNames.size()) {
            return Lists.newArrayList();
        }
        try {
            byte[] rowKey = this.rowKeyIndex < 0 ? this.getRowKey() : m.group(this.rowKeyIndex + 1).getBytes(Charsets.UTF_8);
            Put put = new Put(rowKey);
            for (int i = 0; i < this.colNames.size(); ++i) {
                if (i == this.rowKeyIndex) continue;
                put.addColumn(this.cf, this.colNames.get(i), m.group(i + 1).getBytes(Charsets.UTF_8));
            }
            if (this.depositHeaders) {
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    put.addColumn(this.cf, entry.getKey().getBytes(this.charset), entry.getValue().getBytes(this.charset));
                }
            }
            actions.add(put);
        }
        catch (Exception e) {
            throw new FlumeException("Could not get row key!", (Throwable)e);
        }
        return actions;
    }

    @Override
    public List<Increment> getIncrements() {
        return Lists.newArrayList();
    }

    @Override
    public void close() {
    }
}

