/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.management.ObjectName;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StartGatewaySenderCommand
extends GfshCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"start gateway-sender"}, help="Start the Gateway Sender on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public ResultModel startGatewaySender(@CliOption(key={"id"}, mandatory=true, optionContext="geode.converter.gateway.senderid:disable-string-converter", help="ID of the Gateway Sender.") String senderId, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members on which to start the Gateway Sender.") String[] onGroup, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member on which to start the Gateway Sender.") String[] onMember, @CliOption(key={"clean-queues"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Option to clean existing queue at start of the Gateway Sender. This option is only applicable for Gateway Senders with enabled persistence.") Boolean cleanQueues) {
        List futures;
        String id = senderId.trim();
        Cache cache = this.getCache();
        SystemManagementService service = (SystemManagementService)this.getManagementService();
        Set<DistributedMember> dsMembers = this.findMembers(onGroup, onMember);
        if (dsMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        ExecutorService execService = LoggingExecutors.newCachedThreadPool((String)"Start Sender Command Thread ", (boolean)true);
        ArrayList<Callable<List>> callables = new ArrayList<Callable<List>>();
        for (DistributedMember member : dsMembers) {
            callables.add(() -> {
                GatewaySenderMXBean bean;
                ArrayList<String> statusList = new ArrayList<String>();
                if (cache.getDistributedSystem().getDistributedMember().getId().equals(member.getId())) {
                    bean = service.getLocalGatewaySenderMXBean(id);
                } else {
                    ObjectName objectName = service.getGatewaySenderMBeanName(member, id);
                    bean = (GatewaySenderMXBean)service.getMBeanProxy(objectName, GatewaySenderMXBean.class);
                }
                if (bean != null) {
                    if (bean.isRunning()) {
                        statusList.add(member.getId());
                        statusList.add("Error");
                        statusList.add(CliStrings.format((String)"GatewaySender {0} is already started on member {1}", (Object[])new Object[]{id, member.getId()}));
                    } else {
                        if (cleanQueues.booleanValue()) {
                            bean.startWithCleanQueue();
                        } else {
                            bean.start();
                        }
                        statusList.add(member.getId());
                        statusList.add("OK");
                        statusList.add(CliStrings.format((String)"GatewaySender {0} is started on member {1}", (Object[])new Object[]{id, member.getId()}));
                    }
                } else {
                    statusList.add(member.getId());
                    statusList.add("Error");
                    statusList.add(CliStrings.format((String)"GatewaySender {0} is not available on member {1}", (Object[])new Object[]{id, member.getId()}));
                }
                return statusList;
            });
        }
        Iterator<DistributedMember> memberIterator = dsMembers.iterator();
        try {
            futures = execService.invokeAll(callables);
        }
        catch (InterruptedException ite) {
            ResultModel resultModel = ResultModel.createError(CliStrings.format((String)"Could not invoke start gateway sender {0} operation on members due to {1}", (Object[])new Object[]{id, ite.getMessage()}));
            return resultModel;
        }
        finally {
            execService.shutdown();
        }
        ResultModel resultModel = new ResultModel();
        TabularResultModel resultData = resultModel.addTable("start gateway-sender");
        for (Future future : futures) {
            DistributedMember member = memberIterator.next();
            try {
                List memberStatus = (List)future.get();
                resultData.addMemberStatusResultRow((String)memberStatus.get(0), (String)memberStatus.get(1), (String)memberStatus.get(2));
            }
            catch (InterruptedException | ExecutionException ite) {
                resultData.addMemberStatusResultRow(member.getId(), "Error", CliStrings.format((String)"Could not start gateway sender {0} on member due to {1}", (Object[])new Object[]{id, ite.getMessage()}));
            }
        }
        execService.shutdown();
        return resultModel;
    }
}

