/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexCreationException;
import org.apache.geode.cache.query.MultiIndexCreationException;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.cache.query.internal.index.IndexCreationData;
import org.apache.geode.cache.query.internal.index.PartitionedIndex;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionException;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.cache.partitioned.RegionAdvisor;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class IndexCreationMsg
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    HashSet<IndexCreationData> indexDefinitions;

    IndexCreationMsg(Set recipients, int regionId, ReplyProcessor21 processor, HashSet<IndexCreationData> indexDefinitions) {
        super(recipients, regionId, processor);
        this.indexDefinitions = indexDefinitions;
    }

    public IndexCreationMsg() {
    }

    @Override
    protected boolean failIfRegionMissing() {
        return false;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException, ForceReattemptException {
        PartitionedIndex prIndex;
        HashMap<String, Integer> indexBucketsMap;
        ReplyException replyEx = null;
        boolean result = false;
        List<Index> indexes = null;
        ArrayList<String> failedIndexNames = new ArrayList<String>();
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (IndexCreationData indexCreationData : this.indexDefinitions) {
                sb.append(indexCreationData.getIndexName()).append(" ");
            }
            logger.debug("Processing index creation message on this remote partitioned region vm for indexes: {}", (Object)sb);
        }
        try {
            indexes = pr.createIndexes(true, this.indexDefinitions);
        }
        catch (IndexCreationException e1) {
            replyEx = new ReplyException("Remote Index Creation Failed", e1);
        }
        catch (MultiIndexCreationException exx) {
            failedIndexNames.addAll(exx.getExceptionsMap().keySet());
            if (logger.isDebugEnabled()) {
                StringBuffer exceptionMsgs = new StringBuffer();
                for (Exception ex : exx.getExceptionsMap().values()) {
                    exceptionMsgs.append(ex.getMessage()).append("\n");
                }
                logger.debug("Got an MultiIndexCreationException with \n: {}", (Object)exceptionMsgs);
                logger.debug("{} indexes were created successfully", (Object)failedIndexNames.size());
            }
            replyEx = new ReplyException("Remote Index Creation Failed", exx);
        }
        if (null == replyEx) {
            result = true;
        }
        if (result) {
            indexBucketsMap = new HashMap<String, Integer>();
            for (Index index : indexes) {
                prIndex = (PartitionedIndex)index;
                indexBucketsMap.put(prIndex.getName(), prIndex.getNumberOfIndexedBuckets());
            }
            this.sendReply(this.getSender(), this.getProcessorId(), dm, replyEx, result, indexBucketsMap, pr.getDataStore().getAllLocalBuckets().size());
        } else {
            indexBucketsMap = new HashMap();
            for (IndexCreationData indexCreationData : this.indexDefinitions) {
                if (failedIndexNames.contains(indexCreationData.getIndexName())) continue;
                prIndex = pr.getIndex(indexCreationData.getIndexName());
                indexBucketsMap.put(indexCreationData.getIndexName(), prIndex.getNumberOfIndexedBuckets());
            }
            this.sendReply(this.getSender(), this.getProcessorId(), dm, replyEx, result, indexBucketsMap, pr.getDataStore().getAllLocalBuckets().size());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Multi Index creation completed on remote host and has sent the reply to the originating vm.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ClusterDistributionManager dm) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        Throwable thr = null;
        boolean sendReply = true;
        PartitionedRegion pr = null;
        try {
            block45: {
                if (isDebugEnabled) {
                    logger.debug("Trying to get pr with id: {}", (Object)this.regionId);
                }
                try {
                    if (isDebugEnabled) {
                        logger.debug("Again trying to get pr with id : {}", (Object)this.regionId);
                    }
                    pr = PartitionedRegion.getPRFromId(this.regionId);
                    if (isDebugEnabled) {
                        logger.debug("Index creation message got the pr {}", (Object)pr);
                    }
                    if (null != pr) break block45;
                    boolean wait = true;
                    int attempts = 0;
                    while (wait && attempts < 30) {
                        dm.getCancelCriterion().checkCancelInProgress(null);
                        if (isDebugEnabled) {
                            logger.debug("Waiting for Partitioned Region to be intialized with id {}for processing index creation messages", (Object)this.regionId);
                        }
                        try {
                            boolean interrupted = Thread.interrupted();
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                interrupted = true;
                                dm.getCancelCriterion().checkCancelInProgress(e);
                            }
                            finally {
                                if (interrupted) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                            pr = PartitionedRegion.getPRFromId(this.regionId);
                            if (null != pr) {
                                wait = false;
                                if (isDebugEnabled) {
                                    logger.debug("Indexcreation message got the pr {}", (Object)pr);
                                }
                            }
                            ++attempts;
                        }
                        catch (CancelException ignorAndLoopWait) {
                            if (!isDebugEnabled) continue;
                            logger.debug("IndexCreationMsg waiting for pr to be properly created with prId : {}", (Object)this.regionId);
                        }
                    }
                }
                catch (CancelException letPRInitialized) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Waiting for notification from pr being properly created on {}", (Object)this.regionId);
                    }
                    boolean wait = true;
                    while (wait) {
                        dm.getCancelCriterion().checkCancelInProgress(null);
                        try {
                            boolean interrupted = Thread.interrupted();
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                interrupted = true;
                                dm.getCancelCriterion().checkCancelInProgress(e);
                            }
                            finally {
                                if (interrupted) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                            pr = PartitionedRegion.getPRFromId(this.regionId);
                            wait = false;
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Indexcreation message got the pr {}", (Object)pr);
                        }
                        catch (CancelException ignorAndLoopWait) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("IndexCreationMsg waiting for pr to be properly created with prId : {}", (Object)this.regionId);
                        }
                    }
                }
            }
            if (pr == null) {
                String msg = String.format("Could not get Partitioned Region from Id %s for message %s received on member= %s map= %s", this.regionId, this, dm.getId(), PartitionedRegion.dumpPRId());
                throw new PartitionedRegionException(msg, new RegionNotFoundException(msg));
            }
            sendReply = this.operateOnPartitionedRegion(dm, pr, 0L);
        }
        catch (PRLocallyDestroyedException pre) {
            if (isDebugEnabled) {
                logger.debug("Region is locally Destroyed ");
            }
            thr = pre;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            if (this.processorId == 0) {
                logger.debug("{} exception while processing message:{}", (Object)this, (Object)t.getMessage(), (Object)t);
            } else if (logger.isDebugEnabled(LogMarker.DM_VERBOSE) && t instanceof RuntimeException) {
                logger.debug(LogMarker.DM_VERBOSE, "Exception caught while processing message: {}", (Object)t.getMessage(), (Object)t);
            }
            if (t instanceof RegionDestroyedException && pr != null) {
                if (pr.isClosed) {
                    logger.info("Region is locally destroyed, throwing RegionDestroyedException for {}", (Object)pr);
                    thr = new RegionDestroyedException(String.format("Region is locally destroyed on %s", dm.getId()), pr.getFullPath());
                }
            } else {
                thr = t;
            }
        }
        finally {
            if (sendReply && this.processorId != 0) {
                ReplyException rex = null;
                if (thr != null) {
                    rex = new ReplyException(thr);
                }
                this.sendReply(this.getSender(), this.processorId, dm, rex, pr, 0L);
            }
        }
    }

    public static PartitionMessage.PartitionResponse send(InternalDistributedMember recipient, PartitionedRegion pr, HashSet<IndexCreationData> indexDefinitions) {
        HashSet<Object> recipients;
        RegionAdvisor advisor = (RegionAdvisor)pr.getDistributionAdvisor();
        if (null == recipient) {
            recipients = new HashSet<InternalDistributedMember>(advisor.adviseDataStore());
        } else {
            recipients = new HashSet<InternalDistributedMember>();
            recipients.add(recipient);
        }
        for (InternalDistributedMember internalDistributedMember : recipients) {
            if (!internalDistributedMember.getVersion().isOlderThan((Version)KnownVersion.GFE_81)) continue;
            throw new UnsupportedOperationException("Indexes should not be created during rolling upgrade");
        }
        IndexCreationResponse processor = null;
        if (logger.isDebugEnabled()) {
            logger.debug("Will be sending create index msg to : {}", (Object)((Object)recipients).toString());
        }
        if (recipients.size() > 0) {
            processor = (IndexCreationResponse)new IndexCreationMsg().createReplyProcessor(pr, recipients);
        }
        IndexCreationMsg indexCreationMsg = new IndexCreationMsg(recipients, pr.getPRId(), processor, indexDefinitions);
        indexCreationMsg.setTransactionDistributed(pr.getCache().getTxManager().isDistributed());
        if (logger.isDebugEnabled()) {
            logger.debug("Sending index creation message: {}, to member(s) {}.", (Object)indexCreationMsg, recipients);
        }
        pr.getDistributionManager().putOutgoing(indexCreationMsg);
        return processor;
    }

    @Override
    PartitionMessage.PartitionResponse createReplyProcessor(PartitionedRegion r, Set recipients) {
        return new IndexCreationResponse(r.getSystem(), recipients);
    }

    void sendReply(InternalDistributedMember member, int procId, DistributionManager dm, ReplyException ex, boolean result, Map<String, Integer> indexBucketsMap, int numTotalBuckets) {
        IndexCreationReplyMsg.send(member, procId, dm, ex, result, indexBucketsMap, numTotalBuckets);
    }

    public int getDSFID() {
        return 52;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.indexDefinitions = DataSerializer.readHashSet(in);
    }

    @Override
    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeHashSet(this.indexDefinitions, out);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (IndexCreationData icd : this.indexDefinitions) {
            sb.append(icd.getIndexName()).append(" ");
        }
        return sb.toString();
    }

    public static class IndexCreationReplyMsg
    extends ReplyMessage {
        private boolean result;
        private Map<String, Integer> indexBucketsMap;
        private int numTotalBuckets;
        private boolean isDataStore;

        public IndexCreationReplyMsg() {
        }

        IndexCreationReplyMsg(int processorId, ReplyException ex, boolean result, boolean isDataStore, Map<String, Integer> indexBucketsMap, int numTotalBuckets) {
            super.setException(ex);
            this.result = result;
            this.indexBucketsMap = indexBucketsMap;
            this.numTotalBuckets = numTotalBuckets;
            this.isDataStore = isDataStore;
            this.setProcessorId(processorId);
        }

        @Override
        public int getDSFID() {
            return 68;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.result = in.readBoolean();
            this.indexBucketsMap = (Map)DataSerializer.readObject(in);
            this.numTotalBuckets = in.readInt();
            this.isDataStore = in.readBoolean();
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeBoolean(this.result);
            DataSerializer.writeObject(this.indexBucketsMap, out);
            out.writeInt(this.numTotalBuckets);
            out.writeBoolean(this.isDataStore);
        }

        public static void send(InternalDistributedMember recipient, int processorId, DistributionManager dm, ReplyException ex, boolean result, Map<String, Integer> indexBucketsMap, int numTotalBuckets) {
            IndexCreationReplyMsg indMsg = new IndexCreationReplyMsg(processorId, ex, result, result, indexBucketsMap, numTotalBuckets);
            indMsg.setRecipient(recipient);
            dm.putOutgoing(indMsg);
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 p) {
            IndexCreationResponse processor;
            if (logger.isDebugEnabled()) {
                logger.debug("Processor id is : {}", (Object)this.processorId);
            }
            if ((processor = (IndexCreationResponse)p) != null) {
                processor.setResponse(this.result, this.indexBucketsMap, this.numTotalBuckets);
                processor.process(this);
            }
        }
    }

    public static class IndexCreationResult {
        private Map<String, Integer> indexBucketsMap;
        private int numTotalBuckets;

        IndexCreationResult(Map<String, Integer> indexBucketsMap, int numTotalBuckets) {
            this.indexBucketsMap = indexBucketsMap;
            this.numTotalBuckets = numTotalBuckets;
        }

        public Map<String, Integer> getIndexBucketsMap() {
            return this.indexBucketsMap;
        }
    }

    public static class IndexCreationResponse
    extends PartitionMessage.PartitionResponse {
        private Map<String, Integer> indexBucketsMap;
        private int numTotalBuckets;

        IndexCreationResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, recipients);
        }

        public IndexCreationResult waitForResult() throws CacheException, ForceReattemptException {
            try {
                this.waitForCacheException();
            }
            catch (RuntimeException re) {
                if (re instanceof PartitionedRegionException) {
                    if (!(re.getCause() instanceof RegionNotFoundException)) {
                        throw re;
                    }
                }
                throw re;
            }
            return new IndexCreationResult(this.indexBucketsMap, this.numTotalBuckets);
        }

        public void setResponse(boolean result, Map<String, Integer> indexBucketsMap, int numTotalBuckets) {
            this.indexBucketsMap = indexBucketsMap;
            this.numTotalBuckets = numTotalBuckets;
        }
    }
}

