/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics.platform;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.statistics.LocalStatisticsImpl;
import org.apache.geode.internal.statistics.platform.LinuxProcessStats;
import org.apache.geode.internal.statistics.platform.LinuxSystemStats;
import org.apache.logging.log4j.Logger;

public class LinuxProcFsStatistics {
    @MakeNotStatic
    private static boolean soMaxConnProcessed;
    @MakeNotStatic
    private static int soMaxConn;
    private static final int DEFAULT_PAGESIZE = 4096;
    private static final int OneMeg = 0x100000;
    private static final String pageSizeProperty = "gemfire.statistics.linux.pageSize";
    @MakeNotStatic
    private static CpuStat cpuStatSingleton;
    @Immutable
    private static final int pageSize;
    @Immutable
    private static final int sys_cpus;
    @MakeNotStatic
    private static boolean hasProcVmStat;
    @MakeNotStatic
    private static boolean hasDiskStats;
    @MakeNotStatic
    static SpaceTokenizer tokenizer;
    @MakeNotStatic
    private static int nonPidFilesInProc;
    private static final String CPU_TOKEN = "cpu ";
    private static final String PAGE = "page ";
    private static final String SWAP = "swap ";
    private static final String CTXT = "ctxt ";
    private static final String PROCESSES = "processes ";
    private static final String PGPGIN = "pgpgin ";
    private static final String PGPGOUT = "pgpgout ";
    private static final String PSWPIN = "pswpin ";
    private static final String PSWPOUT = "pswpout ";
    public static final String TCP_SYNCOOKIES_SENT_NAME = "SyncookiesSent";
    public static final String TCP_SYNCOOKIES_RECV_NAME = "SyncookiesRecv";
    public static final String TCP_LISTEN_OVERFLOWS_NAME = "ListenOverflows";
    public static final String TCP_LISTEN_DROPS_NAME = "ListenDrops";

    private LinuxProcFsStatistics() {
    }

    public static int init() {
        nonPidFilesInProc = LinuxProcFsStatistics.getNumberOfNonProcessProcFiles();
        cpuStatSingleton = new CpuStat();
        hasProcVmStat = new File("/proc/vmstat").exists();
        hasDiskStats = new File("/proc/diskstats").exists();
        tokenizer = new SpaceTokenizer();
        return 0;
    }

    public static void close() {
        cpuStatSingleton = null;
    }

    public static void readyRefresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshProcess(int pid, LocalStatisticsImpl stats) {
        if (pid == 0) {
            return;
        }
        try {
            String line;
            File file = new File("/proc/" + pid + "/stat");
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 InputStreamReader isr = new InputStreamReader(fileInputStream);
                 BufferedReader br = new BufferedReader(isr, 2048);){
                line = br.readLine();
            }
            if (line == null) {
                return;
            }
            tokenizer.setString(line);
            tokenizer.skipTokens(22);
            stats.setLong(LinuxProcessStats.imageSizeLONG, tokenizer.nextTokenAsLong() / 0x100000L);
            stats.setLong(LinuxProcessStats.rssSizeLONG, tokenizer.nextTokenAsLong() * (long)pageSize / 0x100000L);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (IOException iOException) {
        }
        finally {
            tokenizer.releaseResources();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void refreshSystem(LocalStatisticsImpl stats) {
        if (cpuStatSingleton == null) {
            return;
        }
        stats.setLong(LinuxSystemStats.processesLONG, (long)LinuxProcFsStatistics.getProcessCount());
        stats.setLong(LinuxSystemStats.cpusLONG, (long)sys_cpus);
        try (FileInputStream fileInputStream = new FileInputStream("/proc/stat");
             InputStreamReader isr = new InputStreamReader(fileInputStream);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                try {
                    if (line.startsWith(CPU_TOKEN)) {
                        int[] cpuData = cpuStatSingleton.calculateStats(line);
                        stats.setLong(LinuxSystemStats.cpuIdleLONG, (long)cpuData[CPU.IDLE.ordinal()]);
                        stats.setLong(LinuxSystemStats.cpuNiceLONG, (long)cpuData[CPU.NICE.ordinal()]);
                        stats.setLong(LinuxSystemStats.cpuSystemLONG, (long)cpuData[CPU.SYSTEM.ordinal()]);
                        stats.setLong(LinuxSystemStats.cpuUserLONG, (long)cpuData[CPU.USER.ordinal()]);
                        stats.setLong(LinuxSystemStats.cpuStealLONG, (long)cpuData[CPU.STEAL.ordinal()]);
                        stats.setLong(LinuxSystemStats.iowaitLONG, (long)cpuData[CPU.IOWAIT.ordinal()]);
                        stats.setLong(LinuxSystemStats.irqLONG, (long)cpuData[CPU.IRQ.ordinal()]);
                        stats.setLong(LinuxSystemStats.softirqLONG, (long)cpuData[CPU.SOFTIRQ.ordinal()]);
                        stats.setLong(LinuxSystemStats.cpuActiveLONG, (long)(100 - cpuData[CPU.IDLE.ordinal()]));
                        stats.setLong(LinuxSystemStats.cpuNonUserLONG, (long)(cpuData[CPU.OTHER.ordinal()] + cpuData[CPU.SYSTEM.ordinal()] + cpuData[CPU.IOWAIT.ordinal()] + cpuData[CPU.IRQ.ordinal()] + cpuData[CPU.SOFTIRQ.ordinal()]));
                        continue;
                    }
                    if (!hasProcVmStat && line.startsWith(PAGE)) {
                        int secondIndex = line.indexOf(" ", PAGE.length());
                        stats.setLong(LinuxSystemStats.pagesPagedInLONG, SpaceTokenizer.parseAsLong(line.substring(PAGE.length(), secondIndex)));
                        stats.setLong(LinuxSystemStats.pagesPagedOutLONG, SpaceTokenizer.parseAsLong(line.substring(secondIndex + 1)));
                        continue;
                    }
                    if (!hasProcVmStat && line.startsWith(SWAP)) {
                        int secondIndex = line.indexOf(" ", SWAP.length());
                        stats.setLong(LinuxSystemStats.pagesSwappedInLONG, SpaceTokenizer.parseAsLong(line.substring(SWAP.length(), secondIndex)));
                        stats.setLong(LinuxSystemStats.pagesSwappedOutLONG, SpaceTokenizer.parseAsLong(line.substring(secondIndex + 1)));
                        continue;
                    }
                    if (line.startsWith(CTXT)) {
                        stats.setLong(LinuxSystemStats.contextSwitchesLONG, SpaceTokenizer.parseAsLong(line.substring(CTXT.length())));
                        continue;
                    }
                    if (!line.startsWith(PROCESSES)) continue;
                    stats.setLong(LinuxSystemStats.processCreatesLONG, (long)SpaceTokenizer.parseAsInt(line.substring(PROCESSES.length())));
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LinuxProcFsStatistics.getLoadAvg(stats);
        LinuxProcFsStatistics.getMemInfo(stats);
        LinuxProcFsStatistics.getDiskStats(stats);
        LinuxProcFsStatistics.getNetStats(stats);
        LinuxProcFsStatistics.getNetStatStats(stats);
        if (hasProcVmStat) {
            LinuxProcFsStatistics.getVmStats(stats);
        }
        tokenizer.releaseResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getLoadAvg(LocalStatisticsImpl stats) {
        try (FileInputStream fileInputStream = new FileInputStream("/proc/loadavg");
             InputStreamReader isr = new InputStreamReader(fileInputStream);
             BufferedReader br = new BufferedReader(isr, 512);){
            String line = br.readLine();
            if (line == null) {
                return;
            }
            tokenizer.setString(line);
            stats.setDouble(LinuxSystemStats.loadAverage1DOUBLE, tokenizer.nextTokenAsDouble());
            stats.setDouble(LinuxSystemStats.loadAverage5DOUBLE, tokenizer.nextTokenAsDouble());
            stats.setDouble(LinuxSystemStats.loadAverage15DOUBLE, tokenizer.nextTokenAsDouble());
        }
        catch (IOException | NoSuchElementException exception) {
        }
        finally {
            tokenizer.releaseResources();
        }
    }

    /*
     * Exception decompiling
     */
    public static long getAvailableMemory(Logger logger) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getMemInfo(LocalStatisticsImpl stats) {
        try (FileInputStream fileInputStream = new FileInputStream("/proc/meminfo");
             InputStreamReader isr = new InputStreamReader(fileInputStream);
             BufferedReader br = new BufferedReader(isr);){
            String line = null;
            while ((line = br.readLine()) != null) {
                try {
                    if (line.startsWith("MemTotal: ")) {
                        tokenizer.setString(line);
                        tokenizer.skipToken();
                        stats.setLong(LinuxSystemStats.physicalMemoryLONG, tokenizer.nextTokenAsLong() / 1024L);
                        continue;
                    }
                    if (line.startsWith("MemFree: ")) {
                        tokenizer.setString(line);
                        tokenizer.skipToken();
                        stats.setLong(LinuxSystemStats.freeMemoryLONG, tokenizer.nextTokenAsLong() / 1024L);
                        continue;
                    }
                    if (line.startsWith("SharedMem: ")) {
                        tokenizer.setString(line);
                        tokenizer.skipToken();
                        stats.setLong(LinuxSystemStats.sharedMemoryLONG, tokenizer.nextTokenAsLong() / 1024L);
                        continue;
                    }
                    if (line.startsWith("Buffers: ")) {
                        tokenizer.setString(line);
                        tokenizer.nextToken();
                        stats.setLong(LinuxSystemStats.bufferMemoryLONG, tokenizer.nextTokenAsLong() / 1024L);
                        continue;
                    }
                    if (line.startsWith("SwapTotal: ")) {
                        tokenizer.setString(line);
                        tokenizer.skipToken();
                        stats.setLong(LinuxSystemStats.allocatedSwapLONG, tokenizer.nextTokenAsLong() / 1024L);
                        continue;
                    }
                    if (line.startsWith("SwapFree: ")) {
                        tokenizer.setString(line);
                        tokenizer.skipToken();
                        stats.setLong(LinuxSystemStats.unallocatedSwapLONG, tokenizer.nextTokenAsLong() / 1024L);
                        continue;
                    }
                    if (line.startsWith("Cached: ")) {
                        tokenizer.setString(line);
                        tokenizer.skipToken();
                        stats.setLong(LinuxSystemStats.cachedMemoryLONG, tokenizer.nextTokenAsLong() / 1024L);
                        continue;
                    }
                    if (line.startsWith("Dirty: ")) {
                        tokenizer.setString(line);
                        tokenizer.skipToken();
                        stats.setLong(LinuxSystemStats.dirtyMemoryLONG, tokenizer.nextTokenAsLong() / 1024L);
                        continue;
                    }
                    if (!line.startsWith("Inact_dirty: ")) continue;
                    tokenizer.setString(line);
                    tokenizer.skipToken();
                    stats.setLong(LinuxSystemStats.dirtyMemoryLONG, tokenizer.nextTokenAsLong() / 1024L);
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
        }
        catch (IOException iOException) {
        }
        finally {
            tokenizer.releaseResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getNetStatStats(LocalStatisticsImpl stats) {
        SpaceTokenizer headerTokenizer = new SpaceTokenizer();
        try (FileInputStream fileInputStream = new FileInputStream("/proc/net/netstat");
             InputStreamReader isr = new InputStreamReader(fileInputStream);
             BufferedReader br = new BufferedReader(isr);){
            String line = br.readLine();
            headerTokenizer.setString(line);
            while ((line = br.readLine()) != null && !line.startsWith("TcpExt:")) {
            }
            tokenizer.setString(line);
            HashSet<String> tokenNames = new HashSet<String>();
            tokenNames.add(TCP_SYNCOOKIES_SENT_NAME);
            tokenNames.add(TCP_SYNCOOKIES_RECV_NAME);
            tokenNames.add(TCP_LISTEN_OVERFLOWS_NAME);
            tokenNames.add(TCP_LISTEN_DROPS_NAME);
            while (headerTokenizer.hasMoreTokens() && !tokenNames.isEmpty()) {
                String currentToken = headerTokenizer.peekToken();
                if (tokenNames.contains(currentToken)) {
                    long statValue = SpaceTokenizer.parseAsLong(tokenizer.peekToken());
                    switch (currentToken) {
                        case "SyncookiesSent": {
                            stats.setLong(LinuxSystemStats.tcpExtSynCookiesSentLONG, statValue);
                            break;
                        }
                        case "SyncookiesRecv": {
                            stats.setLong(LinuxSystemStats.tcpExtSynCookiesRecvLONG, statValue);
                            break;
                        }
                        case "ListenOverflows": {
                            stats.setLong(LinuxSystemStats.tcpExtListenOverflowsLONG, statValue);
                            break;
                        }
                        case "ListenDrops": {
                            stats.setLong(LinuxSystemStats.tcpExtListenDropsLONG, statValue);
                        }
                    }
                    tokenNames.remove(currentToken);
                }
                headerTokenizer.skipToken();
                tokenizer.skipToken();
            }
            if (!soMaxConnProcessed) {
                try (FileInputStream fileInputStream2 = new FileInputStream("/proc/sys/net/core/somaxconn");){
                    InputStreamReader soMaxConnIsr = new InputStreamReader(fileInputStream2);
                    Object object = null;
                    try (BufferedReader br2 = new BufferedReader(soMaxConnIsr);){
                        line = br2.readLine();
                        tokenizer.setString(line);
                        soMaxConn = tokenizer.nextTokenAsInt();
                        soMaxConnProcessed = true;
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (soMaxConnIsr != null) {
                            if (object != null) {
                                try {
                                    soMaxConnIsr.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                soMaxConnIsr.close();
                            }
                        }
                    }
                }
            }
            stats.setLong(LinuxSystemStats.tcpSOMaxConnLONG, (long)soMaxConn);
        }
        catch (IOException | NoSuchElementException exception) {
        }
        finally {
            tokenizer.releaseResources();
            headerTokenizer.releaseResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getNetStats(LocalStatisticsImpl stats) {
        try (FileInputStream fileInputStream = new FileInputStream("/proc/net/dev");
             InputStreamReader isr = new InputStreamReader(fileInputStream);
             BufferedReader br = new BufferedReader(isr);){
            br.readLine();
            br.readLine();
            long lo_recv_packets = 0L;
            long lo_recv_bytes = 0L;
            long other_recv_packets = 0L;
            long other_recv_bytes = 0L;
            long other_recv_errs = 0L;
            long other_recv_drop = 0L;
            long other_xmit_packets = 0L;
            long other_xmit_bytes = 0L;
            long other_xmit_errs = 0L;
            long other_xmit_drop = 0L;
            long other_xmit_colls = 0L;
            String line = null;
            while ((line = br.readLine()) != null) {
                int index = line.indexOf(":");
                boolean isloopback = line.contains("lo:");
                tokenizer.setString(line.substring(index + 1).trim());
                long recv_bytes = tokenizer.nextTokenAsLong();
                long recv_packets = tokenizer.nextTokenAsLong();
                long recv_errs = tokenizer.nextTokenAsLong();
                long recv_drop = tokenizer.nextTokenAsLong();
                tokenizer.skipTokens(4);
                long xmit_bytes = tokenizer.nextTokenAsLong();
                long xmit_packets = tokenizer.nextTokenAsLong();
                long xmit_errs = tokenizer.nextTokenAsLong();
                long xmit_drop = tokenizer.nextTokenAsLong();
                tokenizer.skipToken();
                long xmit_colls = tokenizer.nextTokenAsLong();
                if (isloopback) {
                    lo_recv_packets = recv_packets;
                    lo_recv_bytes = recv_bytes;
                } else {
                    other_recv_packets += recv_packets;
                    other_recv_bytes += recv_bytes;
                }
                other_recv_errs += recv_errs;
                other_recv_drop += recv_drop;
                if (!isloopback) {
                    other_xmit_packets += xmit_packets;
                    other_xmit_bytes += xmit_bytes;
                }
                other_xmit_errs += xmit_errs;
                other_xmit_drop += xmit_drop;
                other_xmit_colls += xmit_colls;
            }
            stats.setLong(LinuxSystemStats.loopbackPacketsLONG, lo_recv_packets);
            stats.setLong(LinuxSystemStats.loopbackBytesLONG, lo_recv_bytes);
            stats.setLong(LinuxSystemStats.recvPacketsLONG, other_recv_packets);
            stats.setLong(LinuxSystemStats.recvBytesLONG, other_recv_bytes);
            stats.setLong(LinuxSystemStats.recvErrorsLONG, other_recv_errs);
            stats.setLong(LinuxSystemStats.recvDropsLONG, other_recv_drop);
            stats.setLong(LinuxSystemStats.xmitPacketsLONG, other_xmit_packets);
            stats.setLong(LinuxSystemStats.xmitBytesLONG, other_xmit_bytes);
            stats.setLong(LinuxSystemStats.xmitErrorsLONG, other_xmit_errs);
            stats.setLong(LinuxSystemStats.xmitDropsLONG, other_xmit_drop);
            stats.setLong(LinuxSystemStats.xmitCollisionsLONG, other_xmit_colls);
        }
        catch (IOException | NoSuchElementException exception) {
        }
        finally {
            tokenizer.releaseResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getDiskStats(LocalStatisticsImpl stats) {
        InputStreamReader isr = null;
        BufferedReader br = null;
        String line = null;
        try {
            isr = hasDiskStats ? new InputStreamReader(new FileInputStream("/proc/diskstats")) : new InputStreamReader(new FileInputStream("/proc/partitions"));
            br = new BufferedReader(isr);
            long readsCompleted = 0L;
            long readsMerged = 0L;
            long sectorsRead = 0L;
            long timeReading = 0L;
            long writesCompleted = 0L;
            long writesMerged = 0L;
            long sectorsWritten = 0L;
            long timeWriting = 0L;
            long iosInProgress = 0L;
            long timeIosInProgress = 0L;
            long ioTime = 0L;
            if (!hasDiskStats) {
                br.readLine();
                br.readLine();
            }
            while ((line = br.readLine()) != null) {
                tokenizer.setString(line);
                String tok = tokenizer.nextToken();
                if (tok.length() == 0 || Character.isWhitespace(tok.charAt(0))) {
                    tok = tokenizer.nextToken();
                }
                tok = tokenizer.nextToken();
                tok = tokenizer.nextToken();
                if (!hasDiskStats) {
                    tok = tokenizer.nextToken();
                }
                if (Character.isDigit(tok.charAt(tok.length() - 1))) continue;
                long tmp_readsCompleted = tokenizer.nextTokenAsLong();
                long tmp_readsMerged = tokenizer.nextTokenAsLong();
                long tmp_sectorsRead = tokenizer.nextTokenAsLong();
                long tmp_timeReading = tokenizer.nextTokenAsLong();
                if (!tokenizer.hasMoreTokens()) continue;
                long tmp_writesCompleted = tokenizer.nextTokenAsLong();
                long tmp_writesMerged = tokenizer.nextTokenAsLong();
                long tmp_sectorsWritten = tokenizer.nextTokenAsLong();
                long tmp_timeWriting = tokenizer.nextTokenAsLong();
                long tmp_iosInProgress = tokenizer.nextTokenAsLong();
                long tmp_timeIosInProgress = tokenizer.nextTokenAsLong();
                long tmp_ioTime = tokenizer.nextTokenAsLong();
                readsCompleted += tmp_readsCompleted;
                readsMerged += tmp_readsMerged;
                sectorsRead += tmp_sectorsRead;
                timeReading += tmp_timeReading;
                writesCompleted += tmp_writesCompleted;
                writesMerged += tmp_writesMerged;
                sectorsWritten += tmp_sectorsWritten;
                timeWriting += tmp_timeWriting;
                iosInProgress += tmp_iosInProgress;
                timeIosInProgress += tmp_timeIosInProgress;
                ioTime += tmp_ioTime;
            }
            int SECTOR_SIZE = 512;
            stats.setLong(LinuxSystemStats.readsCompletedLONG, readsCompleted);
            stats.setLong(LinuxSystemStats.readsMergedLONG, readsMerged);
            stats.setLong(LinuxSystemStats.bytesReadLONG, sectorsRead * 512L);
            stats.setLong(LinuxSystemStats.timeReadingLONG, timeReading);
            stats.setLong(LinuxSystemStats.writesCompletedLONG, writesCompleted);
            stats.setLong(LinuxSystemStats.writesMergedLONG, writesMerged);
            stats.setLong(LinuxSystemStats.bytesWrittenLONG, sectorsWritten * 512L);
            stats.setLong(LinuxSystemStats.timeWritingLONG, timeWriting);
            stats.setLong(LinuxSystemStats.iosInProgressLONG, iosInProgress);
            stats.setLong(LinuxSystemStats.timeIosInProgressLONG, timeIosInProgress);
            stats.setLong(LinuxSystemStats.ioTimeLONG, ioTime);
        }
        catch (IOException | NoSuchElementException exception) {
        }
        finally {
            tokenizer.releaseResources();
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void getVmStats(LocalStatisticsImpl stats) {
        assert (hasProcVmStat) : "getVmStats called when hasVmStat was false";
        try (FileInputStream fileInputStream = new FileInputStream("/proc/vmstat");
             InputStreamReader isr = new InputStreamReader(fileInputStream);
             BufferedReader br = new BufferedReader(isr);){
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith(PGPGIN)) {
                    stats.setLong(LinuxSystemStats.pagesPagedInLONG, SpaceTokenizer.parseAsLong(line.substring(PGPGIN.length())));
                    continue;
                }
                if (line.startsWith(PGPGOUT)) {
                    stats.setLong(LinuxSystemStats.pagesPagedOutLONG, SpaceTokenizer.parseAsLong(line.substring(PGPGOUT.length())));
                    continue;
                }
                if (line.startsWith(PSWPIN)) {
                    stats.setLong(LinuxSystemStats.pagesSwappedInLONG, SpaceTokenizer.parseAsLong(line.substring(PSWPIN.length())));
                    continue;
                }
                if (!line.startsWith(PSWPOUT)) continue;
                stats.setLong(LinuxSystemStats.pagesSwappedOutLONG, SpaceTokenizer.parseAsLong(line.substring(PSWPOUT.length())));
            }
        }
        catch (IOException | NoSuchElementException exception) {
            // empty catch block
        }
    }

    private static int getNumberOfNonProcessProcFiles() {
        File proc = new File("/proc");
        String[] procFiles = proc.list();
        int count = 0;
        if (procFiles != null) {
            for (String filename : procFiles) {
                char c2;
                char c = filename.charAt(0);
                if (Character.isDigit(c) || c == '.' && filename.length() > 1 && Character.isDigit(c2 = filename.charAt(1))) continue;
                ++count;
            }
        }
        return count;
    }

    private static int getProcessCount() {
        File proc = new File("/proc");
        String[] procFiles = proc.list();
        if (procFiles == null) {
            return 0;
        }
        return procFiles.length - nonPidFilesInProc;
    }

    static {
        pageSize = Integer.getInteger(pageSizeProperty, 4096);
        sys_cpus = Runtime.getRuntime().availableProcessors();
    }

    private static class SpaceTokenizer {
        private String str;
        private char[] rawChars;
        private int beginIdx;
        private int endIdx = -1;
        private int nextIdx = -1;

        protected SpaceTokenizer() {
        }

        protected void releaseResources() {
            this.str = null;
            this.rawChars = null;
            this.endIdx = -1;
            this.nextIdx = -1;
        }

        private void nextIdx() {
            int origin = this.nextIdx;
            if (this.endIdx == this.rawChars.length || this.beginIdx == -1) {
                this.endIdx = -1;
                this.nextIdx = -1;
                return;
            }
            this.endIdx = -1;
            this.nextIdx = -1;
            for (int i = origin + 1; i < this.rawChars.length; ++i) {
                char c = this.rawChars[i];
                if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                    if (this.endIdx != -1) continue;
                    this.endIdx = i;
                    continue;
                }
                if (this.endIdx == -1) continue;
                this.nextIdx = i;
                return;
            }
            if (this.endIdx == -1) {
                this.endIdx = this.rawChars.length;
            }
        }

        protected boolean hasMoreTokens() {
            return this.endIdx != -1;
        }

        protected void setString(String data) {
            this.str = data;
            this.rawChars = new char[this.str.length()];
            this.str.getChars(0, this.str.length(), this.rawChars, 0);
            this.beginIdx = 0;
            this.endIdx = -1;
            this.nextIdx = -1;
            this.nextIdx();
        }

        protected boolean skipToken() {
            if (this.hasMoreTokens()) {
                this.beginIdx = this.nextIdx;
                this.nextIdx();
                return true;
            }
            return false;
        }

        protected String nextToken() {
            if (this.hasMoreTokens()) {
                String ret = this.str.substring(this.beginIdx, this.endIdx);
                this.beginIdx = this.nextIdx;
                this.nextIdx();
                return ret;
            }
            throw new NoSuchElementException();
        }

        protected String peekToken() {
            if (this.hasMoreTokens()) {
                return this.str.substring(this.beginIdx, this.endIdx);
            }
            throw new NoSuchElementException();
        }

        protected void skipTokens(int numberToSkip) {
            int remaining = numberToSkip + 1;
            while (--remaining > 0 && this.skipToken()) {
            }
        }

        protected static long parseAsLong(String number) {
            long l = 0L;
            try {
                l = Long.parseLong(number);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return l;
        }

        protected static int parseAsInt(String number) {
            int i = 0;
            try {
                i = Integer.parseInt(number);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return i;
        }

        protected int nextTokenAsInt() {
            int i = 0;
            try {
                i = Integer.parseInt(this.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return i;
        }

        protected long nextTokenAsLong() {
            long l = 0L;
            try {
                l = Long.parseLong(this.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return l;
        }

        protected double nextTokenAsDouble() {
            double d = 0.0;
            try {
                d = Double.parseDouble(this.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return d;
        }
    }

    private static class CpuStat {
        @MakeNotStatic
        private static boolean lastCpuStatsInvalid;
        @MakeNotStatic
        private static List<Long> lastCpuStats;

        public CpuStat() {
            lastCpuStatsInvalid = true;
        }

        public int[] calculateStats(String newStatLine) {
            int i;
            tokenizer.setString(newStatLine);
            tokenizer.skipToken();
            int MAX_CPU_STATS = CPU.values().length;
            ArrayList<Long> newStats = new ArrayList<Long>(10);
            ArrayList<Long> diffs = new ArrayList<Long>(10);
            long total_change = 0L;
            int actualCpuStats = 0;
            long unaccountedCpuUtilization = 0L;
            while (tokenizer.hasMoreTokens()) {
                newStats.add(tokenizer.nextTokenAsLong());
                ++actualCpuStats;
            }
            if (lastCpuStatsInvalid) {
                lastCpuStats = newStats;
                lastCpuStatsInvalid = false;
                for (i = 0; i < MAX_CPU_STATS; ++i) {
                    diffs.add(0L);
                }
                diffs.set(CPU.IDLE.ordinal(), 100L);
            } else {
                for (i = 0; i < actualCpuStats; ++i) {
                    diffs.add((Long)newStats.get(i) - lastCpuStats.get(i));
                    total_change += ((Long)diffs.get(i)).longValue();
                    lastCpuStats.set(i, (Long)newStats.get(i));
                }
                if (total_change == 0L) {
                    total_change = 1L;
                }
                for (i = 0; i < MAX_CPU_STATS; ++i) {
                    if (i >= actualCpuStats) continue;
                    diffs.set(i, (Long)diffs.get(i) * 100L / total_change);
                }
                for (i = MAX_CPU_STATS; i < actualCpuStats; ++i) {
                    unaccountedCpuUtilization += (Long)diffs.get(i) * 100L / total_change;
                }
            }
            int[] ret = new int[MAX_CPU_STATS];
            for (int i2 = 0; i2 < MAX_CPU_STATS; ++i2) {
                if (i2 >= actualCpuStats) continue;
                ret[i2] = ((Long)diffs.get(i2)).intValue();
            }
            int n = CPU.OTHER.ordinal();
            ret[n] = ret[n] + (int)unaccountedCpuUtilization;
            return ret;
        }
    }

    private static enum CPU {
        USER,
        NICE,
        SYSTEM,
        IDLE,
        IOWAIT,
        IRQ,
        SOFTIRQ,
        STEAL,
        OTHER;

    }
}

