/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.RemoteInputStreamServer;
import com.healthmarketscience.rmiio.RemoteStreamMonitor;
import com.healthmarketscience.rmiio.util.InputStreamAdapter;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRemoteInputStream
extends RemoteInputStreamServer {
    private static final long serialVersionUID = 20080212L;
    private final transient InputStreamAdapter _inAdapter;

    public SimpleRemoteInputStream(InputStream in) {
        this(in, DUMMY_MONITOR, 7168);
    }

    public SimpleRemoteInputStream(InputStream in, RemoteStreamMonitor<RemoteInputStreamServer> monitor) {
        this(in, monitor, 7168);
    }

    public SimpleRemoteInputStream(InputStream in, RemoteStreamMonitor<RemoteInputStreamServer> monitor, int chunkSize) {
        super(in, monitor, chunkSize);
        this._inAdapter = InputStreamAdapter.create(in, this._chunkSize);
    }

    @Override
    public boolean usingGZIPCompression() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int availableImpl() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            return this._in.available();
        }
    }

    @Override
    protected byte[] readPacket() throws IOException {
        byte[] packet = this._inAdapter.readPacket();
        if (packet != null) {
            this._monitor.localBytesMoved(this, packet.length);
        }
        return packet;
    }

    @Override
    protected long skip(long n) throws IOException {
        long numSkipped = this._in.skip(n);
        this._monitor.localBytesSkipped(this, numSkipped);
        return numSkipped;
    }
}

