/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

package org.grails.datastore.gorm.proxy;

import grails.core.support.proxy.EntityProxyHandler;
import org.grails.datastore.mapping.proxy.ProxyHandler;

/**
 * Adapts the core Grails proxy handler interface to the GORM one
 *
 * @author Graeme Rocher
 * @since 5.0
 */
public class ProxyHandlerAdapter implements EntityProxyHandler {

    final ProxyHandler delegate;

    public ProxyHandlerAdapter(ProxyHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getProxyIdentifier(Object o) {
        return delegate.getIdentifier(o);
    }

    @Override
    public Class<?> getProxiedClass(Object o) {
        return delegate.getProxiedClass(o);
    }

    @Override
    public boolean isProxy(Object o) {
        return delegate.isProxy(o);
    }

    @Override
    public Object unwrapIfProxy(Object instance) {
        return delegate.unwrap(instance);
    }

    @Override
    public boolean isInitialized(Object o) {
        return delegate.isInitialized(o);
    }

    @Override
    public void initialize(Object o) {
        delegate.initialize(o);
    }

    @Override
    public boolean isInitialized(Object obj, String associationName) {
        return delegate.isInitialized(obj, associationName);
    }
}
