/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.converters;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.storage.relational.converters.SQLExceptionConverter;

public class PostgreSQLExceptionConverter
implements SQLExceptionConverter {
    private static final String DUPLICATED_ENTRY_ERROR_CODE = "23505";

    @Override
    public void toGravitinoException(SQLException sqlException, Entity.EntityType type, String name) throws IOException {
        String errorCode;
        switch (errorCode = sqlException.getSQLState()) {
            case "23505": {
                throw new EntityAlreadyExistsException(sqlException, "The %s entity: %s already exists.", type.name(), name);
            }
        }
        throw new IOException(sqlException);
    }
}

