/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.tag.TagChange;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=RenameTagRequest.class, name="rename"), @JsonSubTypes.Type(value=UpdateTagCommentRequest.class, name="updateComment"), @JsonSubTypes.Type(value=SetTagPropertyRequest.class, name="setProperty"), @JsonSubTypes.Type(value=RemoveTagPropertyRequest.class, name="removeProperty")})
public interface TagUpdateRequest
extends RESTRequest {
    public TagChange tagChange();

    public static class RemoveTagPropertyRequest
    implements TagUpdateRequest {
        @JsonProperty(value="property")
        private final String property;

        public RemoveTagPropertyRequest(String property) {
            this.property = property;
        }

        public RemoveTagPropertyRequest() {
            this.property = null;
        }

        @Override
        public TagChange tagChange() {
            return TagChange.removeProperty((String)this.property);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.property), (Object)"\"property\" must not be blank");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoveTagPropertyRequest)) {
                return false;
            }
            RemoveTagPropertyRequest other = (RemoveTagPropertyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            return !(this$property == null ? other$property != null : !this$property.equals(other$property));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RemoveTagPropertyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            return result;
        }

        public String toString() {
            return "TagUpdateRequest.RemoveTagPropertyRequest(property=" + this.getProperty() + ")";
        }

        public String getProperty() {
            return this.property;
        }
    }

    public static class SetTagPropertyRequest
    implements TagUpdateRequest {
        @JsonProperty(value="property")
        private final String property;
        @JsonProperty(value="value")
        private final String value;

        public SetTagPropertyRequest(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public SetTagPropertyRequest() {
            this.property = null;
            this.value = null;
        }

        @Override
        public TagChange tagChange() {
            return TagChange.setProperty((String)this.property, (String)this.value);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.property), (Object)"\"property\" must not be blank");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.value), (Object)"\"value\" must not be blank");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SetTagPropertyRequest)) {
                return false;
            }
            SetTagPropertyRequest other = (SetTagPropertyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SetTagPropertyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "TagUpdateRequest.SetTagPropertyRequest(property=" + this.getProperty() + ", value=" + this.getValue() + ")";
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class UpdateTagCommentRequest
    implements TagUpdateRequest {
        @JsonProperty(value="newComment")
        private final String newComment;

        public UpdateTagCommentRequest(String newComment) {
            this.newComment = newComment;
        }

        public UpdateTagCommentRequest() {
            this.newComment = null;
        }

        @Override
        public TagChange tagChange() {
            return TagChange.updateComment((String)this.newComment);
        }

        @Override
        public void validate() throws IllegalArgumentException {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateTagCommentRequest)) {
                return false;
            }
            UpdateTagCommentRequest other = (UpdateTagCommentRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newComment = this.getNewComment();
            String other$newComment = other.getNewComment();
            return !(this$newComment == null ? other$newComment != null : !this$newComment.equals(other$newComment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateTagCommentRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newComment = this.getNewComment();
            result = result * 59 + ($newComment == null ? 43 : $newComment.hashCode());
            return result;
        }

        public String toString() {
            return "TagUpdateRequest.UpdateTagCommentRequest(newComment=" + this.getNewComment() + ")";
        }

        public String getNewComment() {
            return this.newComment;
        }
    }

    public static class RenameTagRequest
    implements TagUpdateRequest {
        @JsonProperty(value="newName")
        private final String newName;

        public RenameTagRequest(String newName) {
            this.newName = newName;
        }

        public RenameTagRequest() {
            this.newName = null;
        }

        @Override
        public TagChange tagChange() {
            return TagChange.rename((String)this.newName);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.newName), (Object)"\"newName\" must not be blank");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RenameTagRequest)) {
                return false;
            }
            RenameTagRequest other = (RenameTagRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newName = this.getNewName();
            String other$newName = other.getNewName();
            return !(this$newName == null ? other$newName != null : !this$newName.equals(other$newName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RenameTagRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newName = this.getNewName();
            result = result * 59 + ($newName == null ? 43 : $newName.hashCode());
            return result;
        }

        public String toString() {
            return "TagUpdateRequest.RenameTagRequest(newName=" + this.getNewName() + ")";
        }

        public String getNewName() {
            return this.newName;
        }
    }
}

