/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.util.ArrayList;
import java.util.Map;
import org.apache.gravitino.Audit;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.SupportsRoles;
import org.apache.gravitino.client.MetadataObjectPolicyOperations;
import org.apache.gravitino.client.MetadataObjectTagOperations;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.model.ModelDTO;
import org.apache.gravitino.exceptions.NoSuchPolicyException;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.exceptions.PolicyAlreadyAssociatedException;
import org.apache.gravitino.exceptions.TagAlreadyAssociatedException;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.policy.Policy;
import org.apache.gravitino.policy.SupportsPolicies;
import org.apache.gravitino.shaded.com.google.common.collect.Lists;
import org.apache.gravitino.tag.SupportsTags;
import org.apache.gravitino.tag.Tag;

class GenericModel
implements Model,
SupportsTags,
SupportsPolicies {
    private final ModelDTO modelDTO;
    private final MetadataObjectTagOperations objectTagOperations;
    private final MetadataObjectPolicyOperations objectPolicyOperations;

    GenericModel(ModelDTO modelDTO, RESTClient restClient, Namespace modelNs) {
        this.modelDTO = modelDTO;
        ArrayList<String> modelFullName = Lists.newArrayList(modelNs.level(1), modelNs.level(2), modelDTO.name());
        MetadataObject modelObject = MetadataObjects.of(modelFullName, MetadataObject.Type.MODEL);
        this.objectTagOperations = new MetadataObjectTagOperations(modelNs.level(0), modelObject, restClient);
        this.objectPolicyOperations = new MetadataObjectPolicyOperations(modelNs.level(0), modelObject, restClient);
    }

    @Override
    public Audit auditInfo() {
        return this.modelDTO.auditInfo();
    }

    @Override
    public String name() {
        return this.modelDTO.name();
    }

    @Override
    public String comment() {
        return this.modelDTO.comment();
    }

    @Override
    public Map<String, String> properties() {
        return this.modelDTO.properties();
    }

    @Override
    public int latestVersion() {
        return this.modelDTO.latestVersion();
    }

    @Override
    public SupportsTags supportsTags() {
        return this;
    }

    @Override
    public SupportsPolicies supportsPolicies() {
        return this;
    }

    @Override
    public SupportsRoles supportsRoles() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericModel)) {
            return false;
        }
        GenericModel that = (GenericModel)o;
        return this.modelDTO.equals(that.modelDTO);
    }

    public int hashCode() {
        return this.modelDTO.hashCode();
    }

    @Override
    public String[] listTags() {
        return this.objectTagOperations.listTags();
    }

    @Override
    public Tag[] listTagsInfo() {
        return this.objectTagOperations.listTagsInfo();
    }

    @Override
    public Tag getTag(String name) throws NoSuchTagException {
        return this.objectTagOperations.getTag(name);
    }

    @Override
    public String[] associateTags(String[] tagsToAdd, String[] tagsToRemove) throws TagAlreadyAssociatedException {
        return this.objectTagOperations.associateTags(tagsToAdd, tagsToRemove);
    }

    @Override
    public String[] listPolicies() {
        return this.objectPolicyOperations.listPolicies();
    }

    @Override
    public Policy[] listPolicyInfos() {
        return this.objectPolicyOperations.listPolicyInfos();
    }

    @Override
    public Policy getPolicy(String name) throws NoSuchPolicyException {
        return this.objectPolicyOperations.getPolicy(name);
    }

    @Override
    public String[] associatePolicies(String[] policiesToAdd, String[] policiesToRemove) throws PolicyAlreadyAssociatedException {
        return this.objectPolicyOperations.associatePolicies(policiesToAdd, policiesToRemove);
    }
}

