/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator;

import java.util.List;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.AllocationState;
import org.apache.hadoop.yarn.util.resource.Resources;

public class ContainerAllocation {
    public static final ContainerAllocation LOCALITY_SKIPPED = new ContainerAllocation(null, null, AllocationState.LOCALITY_SKIPPED);
    public static final ContainerAllocation PRIORITY_SKIPPED = new ContainerAllocation(null, null, AllocationState.PRIORITY_SKIPPED);
    public static final ContainerAllocation APP_SKIPPED = new ContainerAllocation(null, null, AllocationState.APP_SKIPPED);
    public static final ContainerAllocation QUEUE_SKIPPED = new ContainerAllocation(null, null, AllocationState.QUEUE_SKIPPED);
    RMContainer containerToBeUnreserved;
    private Resource resourceToBeAllocated = Resources.none();
    AllocationState state;
    NodeType containerNodeType = NodeType.NODE_LOCAL;
    NodeType requestLocalityType = null;
    RMContainer updatedContainer;
    private List<RMContainer> toKillContainers;

    public ContainerAllocation(RMContainer containerToBeUnreserved, Resource resourceToBeAllocated, AllocationState state) {
        this.containerToBeUnreserved = containerToBeUnreserved;
        this.resourceToBeAllocated = resourceToBeAllocated;
        this.state = state;
    }

    public RMContainer getContainerToBeUnreserved() {
        return this.containerToBeUnreserved;
    }

    public Resource getResourceToBeAllocated() {
        if (this.resourceToBeAllocated == null) {
            return Resources.none();
        }
        return this.resourceToBeAllocated;
    }

    public AllocationState getAllocationState() {
        return this.state;
    }

    public NodeType getContainerNodeType() {
        return this.containerNodeType;
    }

    public RMContainer getUpdatedContainer() {
        return this.updatedContainer;
    }

    public void setToKillContainers(List<RMContainer> toKillContainers) {
        this.toKillContainers = toKillContainers;
    }

    public List<RMContainer> getToKillContainers() {
        return this.toKillContainers;
    }
}

