/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBaseTimelineStorageUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseTimelineStorageUtils.class);
    public static final long MILLIS_ONE_DAY = 86400000L;

    private HBaseTimelineStorageUtils() {
    }

    public static Configuration getTimelineServiceHBaseConf(Configuration conf) throws MalformedURLException {
        Configuration hbaseConf;
        if (conf == null) {
            throw new NullPointerException();
        }
        String timelineServiceHBaseConfFileURL = conf.get("yarn.timeline-service.hbase.configuration.file");
        if (timelineServiceHBaseConfFileURL != null && timelineServiceHBaseConfFileURL.length() > 0) {
            LOG.info("Using hbase configuration at " + timelineServiceHBaseConfFileURL);
            hbaseConf = new Configuration(conf);
            Configuration plainHBaseConf = new Configuration(false);
            URL hbaseSiteXML = new URL(timelineServiceHBaseConfFileURL);
            plainHBaseConf.addResource(hbaseSiteXML);
            HBaseConfiguration.merge((Configuration)hbaseConf, (Configuration)plainHBaseConf);
        } else {
            hbaseConf = HBaseConfiguration.create((Configuration)conf);
        }
        return hbaseConf;
    }

    public static byte[] calculateTheClosestNextRowKeyForPrefix(byte[] rowKeyPrefix) {
        int offset;
        for (offset = rowKeyPrefix.length; offset > 0 && rowKeyPrefix[offset - 1] == -1; --offset) {
        }
        if (offset == 0) {
            return HConstants.EMPTY_END_ROW;
        }
        byte[] newStopRow = Arrays.copyOfRange(rowKeyPrefix, 0, offset);
        int n = newStopRow.length - 1;
        newStopRow[n] = (byte)(newStopRow[n] + 1);
        return newStopRow;
    }

    public static void setMetricsTimeRange(Query query, byte[] metricsCf, long tsBegin, long tsEnd) {
        if (tsBegin != 0L || tsEnd != Long.MAX_VALUE) {
            query.setColumnFamilyTimeRange(metricsCf, tsBegin, tsEnd == Long.MAX_VALUE ? Long.MAX_VALUE : tsEnd + 1L);
        }
    }
}

