/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.junit.Assert;
import org.junit.Test;

public class TestHAAuxiliaryPort {
    @Test
    public void testHAAuxiliaryPort() throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.rpc-address.auxiliary-ports", "0,0");
        conf.set("dfs.namenode.rpc-address.auxiliary-ports.ha-nn-uri-0.nn1", "9000,9001");
        conf.set("dfs.namenode.rpc-address.auxiliary-ports.ha-nn-uri-0.nn2", "9000,9001");
        conf.set("dfs.nameservices", "ha-nn-uri-0");
        conf.set("dfs.ha.namenodes.ha-nn-uri-0", "nn1,nn2");
        conf.setBoolean("fs.hdfs.impl.disable.cache", true);
        MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("ha-nn-uri-0").addNN(new MiniDFSNNTopology.NNConf("nn1")).addNN(new MiniDFSNNTopology.NNConf("nn2")));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(topology).numDataNodes(0).build();
        cluster.transitionToActive(0);
        cluster.waitActive();
        NameNode nn0 = cluster.getNameNode(0);
        NameNode nn1 = cluster.getNameNode(1);
        NameNodeRpcServer rpcServer0 = (NameNodeRpcServer)nn0.getRpcServer();
        InetSocketAddress server0RpcAddress = rpcServer0.getRpcAddress();
        Set auxAddrServer0 = rpcServer0.getAuxiliaryRpcAddresses();
        Assert.assertEquals((long)2L, (long)auxAddrServer0.size());
        NameNodeRpcServer rpcServer1 = (NameNodeRpcServer)nn1.getRpcServer();
        InetSocketAddress server1RpcAddress = rpcServer1.getRpcAddress();
        Set auxAddrServer1 = rpcServer1.getAuxiliaryRpcAddresses();
        Assert.assertEquals((long)2L, (long)auxAddrServer1.size());
        URI nn0URI = new URI("hdfs://localhost:" + server0RpcAddress.getPort());
        try (DFSClient client0 = new DFSClient(nn0URI, conf);){
            client0.mkdirs("/test", null, true);
            for (InetSocketAddress auxAddr : auxAddrServer0) {
                nn0URI = new URI("hdfs://localhost:" + auxAddr.getPort());
                DFSClient clientTmp = new DFSClient(nn0URI, conf);
                Throwable throwable = null;
                try {
                    Assert.assertTrue((boolean)clientTmp.exists("/test"));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (clientTmp == null) continue;
                    if (throwable != null) {
                        try {
                            clientTmp.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    clientTmp.close();
                }
            }
        }
        cluster.shutdownNameNode(0);
        cluster.transitionToActive(1);
        URI nn1URI = new URI("hdfs://localhost:" + server1RpcAddress.getPort());
        try (DFSClient client1 = new DFSClient(nn1URI, conf);){
            Assert.assertTrue((boolean)client1.exists("/test"));
            for (InetSocketAddress auxAddr : auxAddrServer1) {
                nn1URI = new URI("hdfs://localhost:" + auxAddr.getPort());
                DFSClient clientTmp = new DFSClient(nn1URI, conf);
                Throwable throwable = null;
                try {
                    Assert.assertTrue((boolean)client1.exists("/test"));
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (clientTmp == null) continue;
                    if (throwable != null) {
                        try {
                            clientTmp.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    clientTmp.close();
                }
            }
        }
    }
}

