/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hdfs.server.federation.metrics.StateStoreMetrics;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUnavailableException;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreSerializableImpl;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.Query;
import org.apache.hadoop.hdfs.server.federation.store.records.QueryResult;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StateStoreFileBaseImpl
extends StateStoreSerializableImpl {
    private static final Logger LOG = LoggerFactory.getLogger(StateStoreFileBaseImpl.class);
    private static final String TMP_MARK = ".tmp";
    private static final long OLD_TMP_RECORD_MS = TimeUnit.SECONDS.toMillis(10L);
    private static final Pattern OLD_TMP_RECORD_PATTERN = Pattern.compile(".+\\.(\\d+)\\.tmp");
    private boolean initialized = false;

    protected abstract <T extends BaseRecord> BufferedReader getReader(String var1);

    @VisibleForTesting
    public abstract <T extends BaseRecord> BufferedWriter getWriter(String var1);

    protected abstract boolean exists(String var1);

    protected abstract boolean mkdir(String var1);

    protected abstract boolean rename(String var1, String var2);

    protected abstract boolean remove(String var1);

    protected abstract List<String> getChildren(String var1);

    protected abstract String getRootDir();

    public void setInitialized(boolean ini) {
        this.initialized = ini;
    }

    @Override
    public boolean initDriver() {
        String rootDir = this.getRootDir();
        try {
            if (rootDir == null) {
                LOG.error("Invalid root directory, unable to initialize driver.");
                return false;
            }
            if (!this.exists(rootDir) && !this.mkdir(rootDir)) {
                LOG.error("Cannot create State Store root directory {}", (Object)rootDir);
                return false;
            }
        }
        catch (Exception ex) {
            LOG.error("Cannot initialize filesystem using root directory {}", (Object)rootDir, (Object)ex);
            return false;
        }
        this.setInitialized(true);
        return true;
    }

    @Override
    public <T extends BaseRecord> boolean initRecordStorage(String className, Class<T> recordClass) {
        String dataDirPath = this.getRootDir() + "/" + className;
        try {
            if (!this.exists(dataDirPath)) {
                LOG.info("{} data directory doesn't exist, creating it", (Object)dataDirPath);
                if (!this.mkdir(dataDirPath)) {
                    LOG.error("Cannot create data directory {}", (Object)dataDirPath);
                    return false;
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Cannot create data directory {}", (Object)dataDirPath, (Object)ex);
            return false;
        }
        return true;
    }

    @Override
    public <T extends BaseRecord> QueryResult<T> get(Class<T> clazz) throws IOException {
        this.verifyDriverReady();
        long start = Time.monotonicNow();
        StateStoreMetrics metrics = this.getMetrics();
        ArrayList<T> ret = new ArrayList<T>();
        try {
            String path = this.getPathForClass(clazz);
            List<String> children = this.getChildren(path);
            for (String child : children) {
                String pathRecord = path + "/" + child;
                if (child.endsWith(TMP_MARK)) {
                    LOG.debug("There is a temporary file {} in {}", (Object)child, (Object)path);
                    if (!StateStoreFileBaseImpl.isOldTempRecord(child)) continue;
                    LOG.warn("Removing {} as it's an old temporary record", (Object)child);
                    this.remove(pathRecord);
                    continue;
                }
                T record = this.getRecord(pathRecord, clazz);
                ret.add(record);
            }
        }
        catch (Exception e) {
            if (metrics != null) {
                metrics.addFailure(Time.monotonicNow() - start);
            }
            String msg = "Cannot fetch records for " + clazz.getSimpleName();
            LOG.error(msg, (Throwable)e);
            throw new IOException(msg, e);
        }
        if (metrics != null) {
            metrics.addRead(Time.monotonicNow() - start);
        }
        return new QueryResult(ret, this.getTime());
    }

    @VisibleForTesting
    public static boolean isOldTempRecord(String pathRecord) {
        if (!pathRecord.endsWith(TMP_MARK)) {
            return false;
        }
        Matcher m = OLD_TMP_RECORD_PATTERN.matcher(pathRecord);
        if (m.find()) {
            long time = Long.parseLong(m.group(1));
            return Time.now() - time > OLD_TMP_RECORD_MS;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T extends BaseRecord> T getRecord(String path, Class<T> clazz) throws IOException {
        BufferedReader reader = this.getReader(path);
        block6: while (true) {
            String line;
            while ((line = reader.readLine()) != null) {
                T t;
                if (line.startsWith("#") || line.length() <= 0) continue;
                try {
                    T record;
                    t = record = this.newRecord(line, clazz, false);
                }
                catch (Exception ex) {
                    try {
                        LOG.error("Cannot parse line {} in file {}", new Object[]{line, path, ex});
                        continue block6;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        throw new IOException("Cannot read " + path + " for record " + clazz.getSimpleName());
                    }
                }
                return t;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private <T extends BaseRecord> String getPathForClass(Class<T> clazz) {
        String className = StateStoreUtils.getRecordName(clazz);
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRootDir());
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append("/");
        }
        sb.append(className);
        return sb.toString();
    }

    @Override
    public boolean isDriverReady() {
        return this.initialized;
    }

    @Override
    public <T extends BaseRecord> boolean putAll(List<T> records, boolean allowUpdate, boolean errorIfExists) throws StateStoreUnavailableException {
        this.verifyDriverReady();
        if (records.isEmpty()) {
            return true;
        }
        long start = Time.monotonicNow();
        StateStoreMetrics metrics = this.getMetrics();
        HashMap<String, Object> toWrite = new HashMap<String, Object>();
        for (Object record : records) {
            Class<?> clazz = record.getClass();
            String path = this.getPathForClass(clazz);
            String primaryKey = StateStoreFileBaseImpl.getPrimaryKey((BaseRecord)record);
            String recordPath = path + "/" + primaryKey;
            if (this.exists(recordPath)) {
                if (allowUpdate) {
                    ((BaseRecord)record).setDateModified(this.getTime());
                    toWrite.put(recordPath, record);
                    continue;
                }
                if (errorIfExists) {
                    LOG.error("Attempt to insert record {} that already exists", (Object)recordPath);
                    if (metrics != null) {
                        metrics.addFailure(Time.monotonicNow() - start);
                    }
                    return false;
                }
                LOG.debug("Not updating {}", record);
                continue;
            }
            toWrite.put(recordPath, record);
        }
        boolean success = true;
        for (Map.Entry entry : toWrite.entrySet()) {
            String recordPath = (String)entry.getKey();
            String recordPathTemp = recordPath + "." + Time.now() + TMP_MARK;
            boolean recordWrittenSuccessfully = true;
            try (BufferedWriter writer = this.getWriter(recordPathTemp);){
                BaseRecord record = (BaseRecord)entry.getValue();
                String line = this.serializeString(record);
                writer.write(line);
            }
            catch (IOException e) {
                LOG.error("Cannot write {}", (Object)recordPathTemp, (Object)e);
                recordWrittenSuccessfully = false;
                success = false;
            }
            if (!recordWrittenSuccessfully || this.rename(recordPathTemp, recordPath)) continue;
            LOG.error("Failed committing record into {}", (Object)recordPath);
            success = false;
        }
        long end = Time.monotonicNow();
        if (metrics != null) {
            if (success) {
                metrics.addWrite(end - start);
            } else {
                metrics.addFailure(end - start);
            }
        }
        return success;
    }

    @Override
    public <T extends BaseRecord> int remove(Class<T> clazz, Query<T> query) throws StateStoreUnavailableException {
        int removed;
        StateStoreMetrics metrics;
        long start;
        block8: {
            this.verifyDriverReady();
            if (query == null) {
                return 0;
            }
            start = Time.monotonicNow();
            metrics = this.getMetrics();
            removed = 0;
            try {
                QueryResult<T> result = this.get(clazz);
                List<T> existingRecords = result.getRecords();
                List<BaseRecord> recordsToRemove = StateStoreUtils.filterMultiple(query, existingRecords);
                boolean success = true;
                for (BaseRecord recordToRemove : recordsToRemove) {
                    String path = this.getPathForClass(clazz);
                    String primaryKey = StateStoreFileBaseImpl.getPrimaryKey(recordToRemove);
                    String recordToRemovePath = path + "/" + primaryKey;
                    if (this.remove(recordToRemovePath)) {
                        ++removed;
                        continue;
                    }
                    LOG.error("Cannot remove record {}", (Object)recordToRemovePath);
                    success = false;
                }
                if (!success) {
                    LOG.error("Cannot remove records {} query {}", clazz, query);
                    if (metrics != null) {
                        metrics.addFailure(Time.monotonicNow() - start);
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Cannot remove records {} query {}", new Object[]{clazz, query, e});
                if (metrics == null) break block8;
                metrics.addFailure(Time.monotonicNow() - start);
            }
        }
        if (removed > 0 && metrics != null) {
            metrics.addRemove(Time.monotonicNow() - start);
        }
        return removed;
    }

    @Override
    public <T extends BaseRecord> boolean removeAll(Class<T> clazz) throws StateStoreUnavailableException {
        this.verifyDriverReady();
        long start = Time.monotonicNow();
        StateStoreMetrics metrics = this.getMetrics();
        boolean success = true;
        String path = this.getPathForClass(clazz);
        List<String> children = this.getChildren(path);
        for (String child : children) {
            String pathRecord = path + "/" + child;
            if (this.remove(pathRecord)) continue;
            success = false;
        }
        if (metrics != null) {
            long time = Time.monotonicNow() - start;
            if (success) {
                metrics.addRemove(time);
            } else {
                metrics.addFailure(time);
            }
        }
        return success;
    }
}

