/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.webjars.WebJarCache;
import org.webjars.WebJarCacheDefault;

@NullMarked
public class WebJarVersionLocator {
    public static final String WEBJARS_PATH_PREFIX = "META-INF/resources/webjars";
    private static final String PROPERTIES_ROOT = "META-INF/maven/";
    private static final String NPM = "org.webjars.npm/";
    private static final String PLAIN = "org.webjars/";
    private static final String POM_PROPERTIES = "/pom.properties";
    private static final String LOCATOR_PROPERTIES = "META-INF/resources/webjars-locator.properties";
    private static final String CACHE_KEY_PREFIX = "version-";
    private static final ClassLoader LOADER = WebJarVersionLocator.class.getClassLoader();
    private final WebJarCache cache;

    public WebJarVersionLocator() {
        this.cache = new WebJarCacheDefault(new ConcurrentHashMap<String, Optional<String>>());
        this.readLocatorProperties();
    }

    WebJarVersionLocator(WebJarCache cache) {
        this.cache = cache;
        this.readLocatorProperties();
    }

    public @Nullable String fullPath(String webJarName, String exactPath) {
        String version = this.version(webJarName);
        if (!this.isEmpty(version)) {
            if (!exactPath.startsWith(version)) {
                return String.format("%s/%s/%s/%s", WEBJARS_PATH_PREFIX, webJarName, version, exactPath);
            }
            return String.format("%s/%s/%s", WEBJARS_PATH_PREFIX, webJarName, exactPath);
        }
        return null;
    }

    public @Nullable String path(String webJarName, String exactPath) {
        String version = this.version(webJarName);
        if (!this.isEmpty(version)) {
            return String.format("%s/%s/%s", webJarName, version, exactPath);
        }
        return null;
    }

    public @Nullable String version(String webJarName) {
        String cacheKey = CACHE_KEY_PREFIX + webJarName;
        Optional<String> optionalVersion = this.cache.computeIfAbsent(cacheKey, key -> {
            InputStream resource = LOADER.getResourceAsStream("META-INF/maven/org.webjars.npm/" + webJarName + POM_PROPERTIES);
            if (resource == null) {
                resource = LOADER.getResourceAsStream("META-INF/maven/org.webjars/" + webJarName + POM_PROPERTIES);
            }
            if (resource != null) {
                Properties properties = new Properties();
                try {
                    properties.load(resource);
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        resource.close();
                    }
                    catch (IOException iOException) {}
                }
                String version = properties.getProperty("version");
                if (version != null) {
                    if (this.hasResourcePath(webJarName, version)) {
                        return Optional.of(version);
                    }
                    if (version.contains("-") && this.hasResourcePath(webJarName, version = version.substring(0, version.indexOf("-")))) {
                        return Optional.of(version);
                    }
                }
            }
            return Optional.empty();
        });
        return optionalVersion.orElse(null);
    }

    private void readLocatorProperties() {
        try {
            Enumeration<URL> resources = LOADER.getResources(LOCATOR_PROPERTIES);
            while (resources.hasMoreElements()) {
                URL resourceUrl = resources.nextElement();
                InputStream resource = resourceUrl.openStream();
                try {
                    Properties properties = new Properties();
                    properties.load(resource);
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        String version;
                        String webJarName = entry.getKey().toString();
                        if (!webJarName.endsWith(".version") || !this.hasResourcePath(webJarName = webJarName.substring(0, webJarName.lastIndexOf(".version")), version = entry.getValue().toString())) continue;
                        this.cache.computeIfAbsent(CACHE_KEY_PREFIX + webJarName, x -> Optional.of(version));
                    }
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("unable to load locator properties", e);
        }
    }

    private boolean hasResourcePath(String webJarName, String path) {
        return LOADER.getResource("META-INF/resources/webjars/" + webJarName + "/" + path) != null;
    }

    private boolean isEmpty(@Nullable String str) {
        return str == null || str.trim().isEmpty();
    }
}

