/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory.statik;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.statik.AbstractStaticPacketFactory;
import org.pcap4j.packet.factory.statik.PacketInstantiater;
import org.pcap4j.packet.namednumber.ProtocolFamily;

public final class StaticProtocolFamilyPacketFactory
extends AbstractStaticPacketFactory<ProtocolFamily> {
    private static final StaticProtocolFamilyPacketFactory INSTANCE = new StaticProtocolFamilyPacketFactory();

    private StaticProtocolFamilyPacketFactory() {
        this.instantiaters.put(ProtocolFamily.PF_INET, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return IpV4Packet.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<IpV4Packet> getTargetClass() {
                return IpV4Packet.class;
            }
        });
        this.instantiaters.put(ProtocolFamily.PF_INET6, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return IpV6Packet.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<IpV6Packet> getTargetClass() {
                return IpV6Packet.class;
            }
        });
    }

    public static StaticProtocolFamilyPacketFactory getInstance() {
        return INSTANCE;
    }
}

