/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring6.web.webflux;

import java.util.Collections;
import java.util.Map;
import org.springframework.web.server.WebSession;
import org.thymeleaf.spring6.web.webflux.ISpringWebFluxWebSession;
import org.thymeleaf.util.Validate;

final class SpringWebFluxWebSession
implements ISpringWebFluxWebSession {
    private final WebSession session;

    SpringWebFluxWebSession(WebSession session) {
        Validate.notNull((Object)session, (String)"Session cannot be null");
        this.session = session;
    }

    public boolean exists() {
        return this.session.isStarted();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.session.getAttributes());
    }

    @Override
    public Object getAttributeValue(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        return this.session.getAttribute(name);
    }

    public void setAttributeValue(String name, Object value) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        if (value == null) {
            this.session.getAttributes().remove(name);
        } else {
            this.session.getAttributes().put(name, value);
        }
    }

    public void removeAttribute(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        this.session.getAttributes().remove(name);
    }

    @Override
    public Object getNativeSessionObject() {
        return this.session;
    }
}

