/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.config;

import org.apache.hertzbeat.common.config.BaseKafkaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="common")
public class CommonProperties {
    private String secret;
    private DataQueueProperties queue;

    public String getSecret() {
        return this.secret;
    }

    public DataQueueProperties getQueue() {
        return this.queue;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setQueue(DataQueueProperties queue) {
        this.queue = queue;
    }

    public static class DataQueueProperties {
        private QueueType type = QueueType.Memory;
        private KafkaProperties kafka;
        private RedisProperties redis;

        public QueueType getType() {
            return this.type;
        }

        public KafkaProperties getKafka() {
            return this.kafka;
        }

        public RedisProperties getRedis() {
            return this.redis;
        }

        public void setType(QueueType type) {
            this.type = type;
        }

        public void setKafka(KafkaProperties kafka) {
            this.kafka = kafka;
        }

        public void setRedis(RedisProperties redis) {
            this.redis = redis;
        }
    }

    public static class KafkaProperties
    extends BaseKafkaProperties {
        private String metricsDataTopic;
        private String metricsDataToStorageTopic;
        private String serviceDiscoveryDataTopic;
        private String alertsDataTopic;

        public String getMetricsDataTopic() {
            return this.metricsDataTopic;
        }

        public String getMetricsDataToStorageTopic() {
            return this.metricsDataToStorageTopic;
        }

        public String getServiceDiscoveryDataTopic() {
            return this.serviceDiscoveryDataTopic;
        }

        public String getAlertsDataTopic() {
            return this.alertsDataTopic;
        }

        public void setMetricsDataTopic(String metricsDataTopic) {
            this.metricsDataTopic = metricsDataTopic;
        }

        public void setMetricsDataToStorageTopic(String metricsDataToStorageTopic) {
            this.metricsDataToStorageTopic = metricsDataToStorageTopic;
        }

        public void setServiceDiscoveryDataTopic(String serviceDiscoveryDataTopic) {
            this.serviceDiscoveryDataTopic = serviceDiscoveryDataTopic;
        }

        public void setAlertsDataTopic(String alertsDataTopic) {
            this.alertsDataTopic = alertsDataTopic;
        }
    }

    public static class RedisProperties {
        private String redisHost;
        private int redisPort;
        private String metricsDataQueueNameToAlerter;
        private String metricsDataQueueNameToPersistentStorage;
        private String metricsDataQueueNameToRealTimeStorage;
        private String metricsDataQueueNameForServiceDiscovery;
        private String alertsDataQueueName;

        public String getRedisHost() {
            return this.redisHost;
        }

        public int getRedisPort() {
            return this.redisPort;
        }

        public String getMetricsDataQueueNameToAlerter() {
            return this.metricsDataQueueNameToAlerter;
        }

        public String getMetricsDataQueueNameToPersistentStorage() {
            return this.metricsDataQueueNameToPersistentStorage;
        }

        public String getMetricsDataQueueNameToRealTimeStorage() {
            return this.metricsDataQueueNameToRealTimeStorage;
        }

        public String getMetricsDataQueueNameForServiceDiscovery() {
            return this.metricsDataQueueNameForServiceDiscovery;
        }

        public String getAlertsDataQueueName() {
            return this.alertsDataQueueName;
        }

        public void setRedisHost(String redisHost) {
            this.redisHost = redisHost;
        }

        public void setRedisPort(int redisPort) {
            this.redisPort = redisPort;
        }

        public void setMetricsDataQueueNameToAlerter(String metricsDataQueueNameToAlerter) {
            this.metricsDataQueueNameToAlerter = metricsDataQueueNameToAlerter;
        }

        public void setMetricsDataQueueNameToPersistentStorage(String metricsDataQueueNameToPersistentStorage) {
            this.metricsDataQueueNameToPersistentStorage = metricsDataQueueNameToPersistentStorage;
        }

        public void setMetricsDataQueueNameToRealTimeStorage(String metricsDataQueueNameToRealTimeStorage) {
            this.metricsDataQueueNameToRealTimeStorage = metricsDataQueueNameToRealTimeStorage;
        }

        public void setMetricsDataQueueNameForServiceDiscovery(String metricsDataQueueNameForServiceDiscovery) {
            this.metricsDataQueueNameForServiceDiscovery = metricsDataQueueNameForServiceDiscovery;
        }

        public void setAlertsDataQueueName(String alertsDataQueueName) {
            this.alertsDataQueueName = alertsDataQueueName;
        }
    }

    public static enum QueueType {
        Memory,
        Kafka,
        Netty,
        Rabbit_Mq,
        Redis;

    }
}

