/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.config;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.orm.jpa.JpaBaseConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.EclipseLinkJpaVendorAdapter;
import org.springframework.transaction.jta.JtaTransactionManager;

@Configuration
@ConditionalOnProperty(prefix="spring.datasource", name={"url"})
public class EclipseLinkJpaConfiguration
extends JpaBaseConfiguration {
    protected EclipseLinkJpaConfiguration(DataSource dataSource, JpaProperties properties, ObjectProvider<JtaTransactionManager> jtaTransactionManager) {
        super(dataSource, properties, jtaTransactionManager);
    }

    protected AbstractJpaVendorAdapter createJpaVendorAdapter() {
        return new EclipseLinkJpaVendorAdapter();
    }

    protected Map<String, Object> getVendorProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("eclipselink.ddl-generation", "create-or-extend-tables");
        map.put("eclipselink.session.customizer", "org.apache.hertzbeat.common.config.EclipseLinkCustomizer");
        map.put("eclipselink.jdbc.allow-native-sql-queries", "true");
        map.put("eclipselink.weaving", "true");
        return map;
    }
}

