/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.basic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class UnaryFilter<T extends Comparable<T>>
implements Filter,
Serializable {
    private static final long serialVersionUID = 1431606024929453556L;
    protected T value;
    protected FilterType filterType;

    public UnaryFilter() {
    }

    protected UnaryFilter(T value, FilterType filterType) {
        this.value = value;
        this.filterType = filterType;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public abstract String toString();

    @Override
    public abstract Filter copy();

    @Override
    public void serialize(DataOutputStream outputStream) {
        try {
            outputStream.write(this.getSerializeId().ordinal());
            outputStream.write(this.filterType.ordinal());
            ReadWriteIOUtils.writeObject(this.value, outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.filterType = FilterType.values()[buffer.get()];
        this.value = (Comparable)ReadWriteIOUtils.readObject(buffer);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UnaryFilter)) {
            return false;
        }
        UnaryFilter other = (UnaryFilter)obj;
        return this.value.equals(other.value) && this.filterType.equals((Object)other.filterType) && this.getSerializeId().equals((Object)other.getSerializeId());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.filterType, this.getSerializeId()});
    }
}

