/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.dto.query;

import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Query Request Data")
public class DatasourceQuery {
    @Schema(title="Ref Id, unique id for the query")
    private String refId;
    @Schema(title="datasource name")
    private String datasource;
    @Schema(title="query expr, like prometheus query")
    private String expr;
    @Schema(title="query expr type, like promql or sql or influxql")
    private String exprType;
    @Schema(title="query range type, like range or instant")
    private String timeType;
    @Schema(title="query range start time")
    private Long start;
    @Schema(title="query range end time")
    private Long end;
    @Schema(title="query time step, like 5m or 1h")
    private String step;

    public static DatasourceQueryBuilder builder() {
        return new DatasourceQueryBuilder();
    }

    public String getRefId() {
        return this.refId;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public String getExpr() {
        return this.expr;
    }

    public String getExprType() {
        return this.exprType;
    }

    public String getTimeType() {
        return this.timeType;
    }

    public Long getStart() {
        return this.start;
    }

    public Long getEnd() {
        return this.end;
    }

    public String getStep() {
        return this.step;
    }

    public void setRefId(String refId) {
        this.refId = refId;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public void setExpr(String expr) {
        this.expr = expr;
    }

    public void setExprType(String exprType) {
        this.exprType = exprType;
    }

    public void setTimeType(String timeType) {
        this.timeType = timeType;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public void setEnd(Long end) {
        this.end = end;
    }

    public void setStep(String step) {
        this.step = step;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatasourceQuery)) {
            return false;
        }
        DatasourceQuery other = (DatasourceQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$start = this.getStart();
        Long other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Long this$end = this.getEnd();
        Long other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        String this$refId = this.getRefId();
        String other$refId = other.getRefId();
        if (this$refId == null ? other$refId != null : !this$refId.equals(other$refId)) {
            return false;
        }
        String this$datasource = this.getDatasource();
        String other$datasource = other.getDatasource();
        if (this$datasource == null ? other$datasource != null : !this$datasource.equals(other$datasource)) {
            return false;
        }
        String this$expr = this.getExpr();
        String other$expr = other.getExpr();
        if (this$expr == null ? other$expr != null : !this$expr.equals(other$expr)) {
            return false;
        }
        String this$exprType = this.getExprType();
        String other$exprType = other.getExprType();
        if (this$exprType == null ? other$exprType != null : !this$exprType.equals(other$exprType)) {
            return false;
        }
        String this$timeType = this.getTimeType();
        String other$timeType = other.getTimeType();
        if (this$timeType == null ? other$timeType != null : !this$timeType.equals(other$timeType)) {
            return false;
        }
        String this$step = this.getStep();
        String other$step = other.getStep();
        return !(this$step == null ? other$step != null : !this$step.equals(other$step));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatasourceQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Long $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        String $refId = this.getRefId();
        result = result * 59 + ($refId == null ? 43 : $refId.hashCode());
        String $datasource = this.getDatasource();
        result = result * 59 + ($datasource == null ? 43 : $datasource.hashCode());
        String $expr = this.getExpr();
        result = result * 59 + ($expr == null ? 43 : $expr.hashCode());
        String $exprType = this.getExprType();
        result = result * 59 + ($exprType == null ? 43 : $exprType.hashCode());
        String $timeType = this.getTimeType();
        result = result * 59 + ($timeType == null ? 43 : $timeType.hashCode());
        String $step = this.getStep();
        result = result * 59 + ($step == null ? 43 : $step.hashCode());
        return result;
    }

    public String toString() {
        return "DatasourceQuery(refId=" + this.getRefId() + ", datasource=" + this.getDatasource() + ", expr=" + this.getExpr() + ", exprType=" + this.getExprType() + ", timeType=" + this.getTimeType() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ", step=" + this.getStep() + ")";
    }

    public DatasourceQuery(String refId, String datasource, String expr, String exprType, String timeType, Long start, Long end, String step) {
        this.refId = refId;
        this.datasource = datasource;
        this.expr = expr;
        this.exprType = exprType;
        this.timeType = timeType;
        this.start = start;
        this.end = end;
        this.step = step;
    }

    public DatasourceQuery() {
    }

    public static class DatasourceQueryBuilder {
        private String refId;
        private String datasource;
        private String expr;
        private String exprType;
        private String timeType;
        private Long start;
        private Long end;
        private String step;

        DatasourceQueryBuilder() {
        }

        public DatasourceQueryBuilder refId(String refId) {
            this.refId = refId;
            return this;
        }

        public DatasourceQueryBuilder datasource(String datasource) {
            this.datasource = datasource;
            return this;
        }

        public DatasourceQueryBuilder expr(String expr) {
            this.expr = expr;
            return this;
        }

        public DatasourceQueryBuilder exprType(String exprType) {
            this.exprType = exprType;
            return this;
        }

        public DatasourceQueryBuilder timeType(String timeType) {
            this.timeType = timeType;
            return this;
        }

        public DatasourceQueryBuilder start(Long start) {
            this.start = start;
            return this;
        }

        public DatasourceQueryBuilder end(Long end) {
            this.end = end;
            return this;
        }

        public DatasourceQueryBuilder step(String step) {
            this.step = step;
            return this;
        }

        public DatasourceQuery build() {
            return new DatasourceQuery(this.refId, this.datasource, this.expr, this.exprType, this.timeType, this.start, this.end, this.step);
        }

        public String toString() {
            return "DatasourceQuery.DatasourceQueryBuilder(refId=" + this.refId + ", datasource=" + this.datasource + ", expr=" + this.expr + ", exprType=" + this.exprType + ", timeType=" + this.timeType + ", start=" + this.start + ", end=" + this.end + ", step=" + this.step + ")";
        }
    }
}

