/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.Schema;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CachingFactory<CreatedT>
implements Factory<CreatedT> {
    private transient @Nullable ConcurrentHashMap<Class, CreatedT> cache = null;
    private final Factory<CreatedT> innerFactory;

    public CachingFactory(Factory<CreatedT> innerFactory) {
        this.innerFactory = innerFactory;
    }

    @Override
    public CreatedT create(Class<?> clazz, Schema schema) {
        CreatedT cached;
        if (this.cache == null) {
            this.cache = new ConcurrentHashMap();
        }
        if ((cached = this.cache.get(clazz)) != null) {
            return cached;
        }
        cached = this.innerFactory.create(clazz, schema);
        this.cache.put(clazz, cached);
        return cached;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachingFactory that = (CachingFactory)o;
        return this.innerFactory.equals(that.innerFactory);
    }

    public int hashCode() {
        return Objects.hash(this.innerFactory);
    }
}

