/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

class ByteBuddyLocalVariableManager {
    private int nextLocalVariableIndex;

    public ByteBuddyLocalVariableManager(int numFunctionArgs) {
        this.nextLocalVariableIndex = numFunctionArgs;
    }

    public int createVariable() {
        return this.nextLocalVariableIndex++;
    }

    public StackManipulation readVariable(int variableIndex) {
        Preconditions.checkArgument((variableIndex < this.nextLocalVariableIndex ? 1 : 0) != 0);
        return MethodVariableAccess.REFERENCE.loadFrom(variableIndex);
    }

    StackManipulation readVariable(int variableIndex, Class<?> type) {
        return new StackManipulation.Compound(new StackManipulation[]{this.readVariable(variableIndex), TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(type))});
    }

    StackManipulation writeVariable(int variableIndex) {
        Preconditions.checkArgument((variableIndex < this.nextLocalVariableIndex ? 1 : 0) != 0);
        return MethodVariableAccess.REFERENCE.storeAt(variableIndex);
    }

    StackManipulation copy(int sourceVariableIndex, int destVariableIndex) {
        return new StackManipulation.Compound(new StackManipulation[]{this.readVariable(sourceVariableIndex), this.writeVariable(destVariableIndex)});
    }

    BackupLocalVariable backupVariable(int variableToBackup) {
        return new BackupLocalVariable(variableToBackup);
    }

    int getTotalNumVariables() {
        return this.nextLocalVariableIndex;
    }

    public class BackupLocalVariable {
        private final int variableToBackup;
        private final int tempVariable;

        public BackupLocalVariable(int variableToBackup) {
            this.variableToBackup = variableToBackup;
            this.tempVariable = ByteBuddyLocalVariableManager.this.createVariable();
        }

        public StackManipulation backup() {
            return ByteBuddyLocalVariableManager.this.copy(this.variableToBackup, this.tempVariable);
        }

        public StackManipulation restore() {
            return ByteBuddyLocalVariableManager.this.copy(this.tempVariable, this.variableToBackup);
        }
    }
}

