/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Multimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Multimaps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Ordering;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.reflect.ClassPath;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.reflect.Invokable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.reflect.Parameter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.reflect.TypeToken;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ApiSurface {
    private static final Logger LOG = LoggerFactory.getLogger(ApiSurface.class);
    private final Set<Class<?>> rootClasses;
    private final Set<Pattern> patternsToPrune;
    private Multimap<Class<?>, Class<?>> exposedToExposers = null;
    private Pattern prunedPattern = null;
    private Set<Type> visited = null;

    public static Matcher<Class<?>> classesInPackage(String packageName) {
        return new Matchers.ClassInPackage(packageName);
    }

    public static Matcher<ApiSurface> containsOnlyClassesMatching(Set<Matcher<Class<?>>> classMatchers) {
        return new Matchers.ClassesInSurfaceMatcher(classMatchers);
    }

    @SafeVarargs
    public static Matcher<ApiSurface> containsOnlyClassesMatching(Matcher<Class<?>> ... classMatchers) {
        return new Matchers.ClassesInSurfaceMatcher(Sets.newHashSet((Object[])classMatchers));
    }

    public static Matcher<ApiSurface> containsOnlyPackages(String ... packageNames) {
        return ApiSurface.containsOnlyPackages(Sets.newHashSet((Object[])packageNames));
    }

    public static Matcher<ApiSurface> containsOnlyPackages(Set<String> packageNames) {
        Function packageNameToClassMatcher = ApiSurface::classesInPackage;
        ImmutableSet classesInPackages = FluentIterable.from(packageNames).transform(packageNameToClassMatcher).toSet();
        return ApiSurface.containsOnlyClassesMatching(classesInPackages);
    }

    public static ApiSurface empty() {
        LOG.debug("Returning an empty ApiSurface");
        return new ApiSurface(Collections.emptySet(), Collections.emptySet());
    }

    public static ApiSurface ofPackage(String packageName, ClassLoader classLoader) throws IOException {
        return ApiSurface.empty().includingPackage(packageName, classLoader);
    }

    public static ApiSurface ofPackage(Package aPackage, ClassLoader classLoader) throws IOException {
        return ApiSurface.ofPackage(aPackage.getName(), classLoader);
    }

    public static ApiSurface ofClass(Class<?> clazz) {
        return ApiSurface.empty().includingClass(clazz);
    }

    public ApiSurface includingPackage(String packageName, ClassLoader classLoader) throws IOException {
        ClassPath classPath = ClassPath.from((ClassLoader)classLoader);
        HashSet newRootClasses = Sets.newHashSet();
        for (ClassPath.ClassInfo classInfo : classPath.getTopLevelClassesRecursive(packageName)) {
            Class clazz = null;
            try {
                clazz = classInfo.load();
            }
            catch (NoClassDefFoundError e) {
                LOG.warn("Failed to load class: {}", (Object)classInfo.toString(), (Object)e);
                continue;
            }
            if (!this.exposed(clazz.getModifiers())) continue;
            newRootClasses.add(clazz);
        }
        LOG.debug("Including package {} and subpackages: {}", (Object)packageName, (Object)newRootClasses);
        newRootClasses.addAll(this.rootClasses);
        return new ApiSurface(newRootClasses, this.patternsToPrune);
    }

    public ApiSurface includingClass(Class<?> clazz) {
        HashSet newRootClasses = Sets.newHashSet();
        LOG.debug("Including class {}", clazz);
        newRootClasses.add(clazz);
        newRootClasses.addAll(this.rootClasses);
        return new ApiSurface(newRootClasses, this.patternsToPrune);
    }

    public ApiSurface pruningPrefix(String prefix) {
        return this.pruningPattern(Pattern.compile(Pattern.quote(prefix) + ".*"));
    }

    public ApiSurface pruningClassName(String className) {
        return this.pruningPattern(Pattern.compile(Pattern.quote(className)));
    }

    public ApiSurface pruningClass(Class<?> clazz) {
        return this.pruningClassName(clazz.getName());
    }

    public ApiSurface pruningPattern(Pattern pattern) {
        HashSet newPatterns = Sets.newHashSet();
        newPatterns.addAll(this.patternsToPrune);
        newPatterns.add(pattern);
        return new ApiSurface(this.rootClasses, newPatterns);
    }

    public ApiSurface pruningPattern(String patternString) {
        return this.pruningPattern(Pattern.compile(patternString));
    }

    public Set<Class<?>> getRootClasses() {
        return this.rootClasses;
    }

    public Set<Class<?>> getExposedClasses() {
        return this.getExposedToExposers().keySet();
    }

    public List<Class<?>> getAnyExposurePath(Class<?> exposedClass) {
        HashSet excluded = Sets.newHashSet();
        excluded.add(exposedClass);
        List<Class<?>> path = this.getAnyExposurePath(exposedClass, excluded);
        if (path == null) {
            throw new IllegalArgumentException("Class " + exposedClass + " has no path back to any root class. It should never have been considered exposed.");
        }
        return path;
    }

    private List<Class<?>> getAnyExposurePath(Class<?> exposedClass, Set<Class<?>> excluded) {
        ArrayList exposurePath = Lists.newArrayList();
        exposurePath.add(exposedClass);
        Collection exposers = this.getExposedToExposers().get(exposedClass);
        if (exposers.isEmpty()) {
            throw new IllegalArgumentException("Class " + exposedClass + " is not exposed.");
        }
        for (Class exposer : exposers) {
            if (excluded.contains(exposer)) continue;
            if (exposer == null) {
                return exposurePath;
            }
            List<Class<?>> restOfPath = this.getAnyExposurePath(exposer, (Set<Class<?>>)Sets.union(excluded, (Set)Sets.newHashSet((Object[])new Class[]{exposer})));
            if (restOfPath == null) continue;
            exposurePath.addAll(restOfPath);
            return exposurePath;
        }
        return null;
    }

    private ApiSurface(Set<Class<?>> rootClasses, Set<Pattern> patternsToPrune) {
        this.rootClasses = rootClasses;
        this.patternsToPrune = patternsToPrune;
    }

    private Multimap<Class<?>, Class<?>> getExposedToExposers() {
        if (this.exposedToExposers == null) {
            this.constructExposedToExposers();
        }
        return this.exposedToExposers;
    }

    private void constructExposedToExposers() {
        this.visited = Sets.newHashSet();
        this.exposedToExposers = Multimaps.newSetMultimap((Map)Maps.newHashMap(), Sets::newHashSet);
        for (Class<?> clazz : this.rootClasses) {
            this.addExposedTypes(clazz, null);
        }
    }

    private Pattern getPrunedPattern() {
        if (this.prunedPattern == null) {
            this.constructPrunedPattern();
        }
        return this.prunedPattern;
    }

    private void constructPrunedPattern() {
        HashSet prunedPatternStrings = Sets.newHashSet();
        for (Pattern patternToPrune : this.patternsToPrune) {
            prunedPatternStrings.add(patternToPrune.pattern());
        }
        this.prunedPattern = Pattern.compile("(" + Joiner.on((String)")|(").join((Iterable)prunedPatternStrings) + ")");
    }

    private boolean pruned(Type type) {
        return this.pruned(TypeToken.of((Type)type).getRawType());
    }

    private boolean pruned(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.isArray() || clazz.getCanonicalName().equals("jdk.internal.HotSpotIntrinsicCandidate") || this.getPrunedPattern().matcher(clazz.getName()).matches();
    }

    private boolean done(Type type) {
        return this.visited.contains(type);
    }

    private void recordExposure(Class<?> exposed, Class<?> cause) {
        this.exposedToExposers.put(exposed, cause);
    }

    private void recordExposure(Type exposed, Class<?> cause) {
        this.exposedToExposers.put((Object)TypeToken.of((Type)exposed).getRawType(), cause);
    }

    private void visit(Type type) {
        this.visited.add(type);
    }

    private void addExposedTypes(TypeToken type, Class<?> cause) {
        LOG.debug("Adding exposed types from {}, which is the type in type token {}", (Object)type.getType(), (Object)type);
        this.addExposedTypes(type.getType(), cause);
    }

    private void addExposedTypes(Type type, Class<?> cause) {
        if (type instanceof TypeVariable) {
            LOG.debug("Adding exposed types from {}, which is a type variable", (Object)type);
            this.addExposedTypes((TypeVariable)type, cause);
        } else if (type instanceof WildcardType) {
            LOG.debug("Adding exposed types from {}, which is a wildcard type", (Object)type);
            this.addExposedTypes((WildcardType)type, cause);
        } else if (type instanceof GenericArrayType) {
            LOG.debug("Adding exposed types from {}, which is a generic array type", (Object)type);
            this.addExposedTypes((GenericArrayType)type, cause);
        } else if (type instanceof ParameterizedType) {
            LOG.debug("Adding exposed types from {}, which is a parameterized type", (Object)type);
            this.addExposedTypes((ParameterizedType)type, cause);
        } else if (type instanceof Class) {
            LOG.debug("Adding exposed types from {}, which is a class", (Object)type);
            this.addExposedTypes((Class)type, cause);
        } else {
            throw new IllegalArgumentException("Unknown implementation of Type");
        }
    }

    private void addExposedTypes(TypeVariable type, Class<?> cause) {
        if (this.done(type)) {
            return;
        }
        this.visit(type);
        for (Type bound : type.getBounds()) {
            LOG.debug("Adding exposed types from {}, which is a type bound on {}", (Object)bound, (Object)type);
            this.addExposedTypes(bound, cause);
        }
    }

    private void addExposedTypes(WildcardType type, Class<?> cause) {
        this.visit(type);
        for (Type lowerBound : type.getLowerBounds()) {
            LOG.debug("Adding exposed types from {}, which is a type lower bound on wildcard type {}", (Object)lowerBound, (Object)type);
            this.addExposedTypes(lowerBound, cause);
        }
        for (Type upperBound : type.getUpperBounds()) {
            LOG.debug("Adding exposed types from {}, which is a type upper bound on wildcard type {}", (Object)upperBound, (Object)type);
            this.addExposedTypes(upperBound, cause);
        }
    }

    private void addExposedTypes(GenericArrayType type, Class<?> cause) {
        if (this.done(type)) {
            return;
        }
        this.visit(type);
        LOG.debug("Adding exposed types from {}, which is the component type on generic array type {}", (Object)type.getGenericComponentType(), (Object)type);
        this.addExposedTypes(type.getGenericComponentType(), cause);
    }

    private void addExposedTypes(ParameterizedType type, Class<?> cause) {
        boolean alreadyDone = this.done(type);
        if (!this.pruned(type)) {
            this.visit(type);
            this.recordExposure(type, cause);
        }
        if (alreadyDone) {
            return;
        }
        LOG.debug("Adding exposed types from {}, which is the raw type on parameterized type {}", (Object)type.getRawType(), (Object)type);
        this.addExposedTypes(type.getRawType(), cause);
        for (Type typeArg : type.getActualTypeArguments()) {
            LOG.debug("Adding exposed types from {}, which is a type argument on parameterized type {}", (Object)typeArg, (Object)type);
            this.addExposedTypes(typeArg, cause);
        }
    }

    private void addExposedTypes(Class<?> clazz, Class<?> cause) {
        if (this.pruned(clazz)) {
            return;
        }
        boolean alreadyDone = this.done(clazz);
        this.visit(clazz);
        this.recordExposure(clazz, cause);
        if (alreadyDone || this.pruned(clazz)) {
            return;
        }
        TypeToken token = TypeToken.of(clazz);
        for (TypeToken superType : token.getTypes()) {
            if (superType.equals((Object)token)) continue;
            LOG.debug("Adding exposed types from {}, which is a super type token on {}", (Object)superType, clazz);
            this.addExposedTypes(superType, clazz);
        }
        for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
            if (!this.exposed(clazz2.getModifiers())) continue;
            LOG.debug("Adding exposed types from {}, which is an exposed inner class of {}", clazz2, clazz);
            this.addExposedTypes(clazz2, clazz);
        }
        for (AnnotatedElement annotatedElement : clazz.getDeclaredFields()) {
            if (!this.exposed(((Field)annotatedElement).getModifiers())) continue;
            LOG.debug("Adding exposed types from {}, which is an exposed field on {}", (Object)annotatedElement, clazz);
            this.addExposedTypes((Field)annotatedElement, clazz);
        }
        for (Invokable invokable : this.getExposedInvokables(token)) {
            LOG.debug("Adding exposed types from {}, which is an exposed invokable on {}", (Object)invokable, clazz);
            this.addExposedTypes(invokable, clazz);
        }
    }

    private void addExposedTypes(Invokable<?, ?> invokable, Class<?> cause) {
        this.addExposedTypes(invokable.getReturnType(), cause);
        for (Annotation annotation : invokable.getAnnotations()) {
            Class<? extends Annotation> annotationClass = annotation.annotationType();
            if (!Modifier.isPublic(annotationClass.getModifiers())) continue;
            LOG.debug("Adding exposed types from {}, which is an annotation on invokable {}", (Object)annotation, invokable);
            this.addExposedTypes(annotationClass, cause);
        }
        for (Parameter parameter : invokable.getParameters()) {
            LOG.debug("Adding exposed types from {}, which is a parameter on invokable {}", (Object)parameter, invokable);
            this.addExposedTypes(parameter, cause);
        }
        for (TypeToken exceptionType : invokable.getExceptionTypes()) {
            LOG.debug("Adding exposed types from {}, which is an exception type on invokable {}", (Object)exceptionType, invokable);
            this.addExposedTypes(exceptionType, cause);
        }
    }

    private void addExposedTypes(Parameter parameter, Class<?> cause) {
        LOG.debug("Adding exposed types from {}, which is the type of parameter {}", (Object)parameter.getType(), (Object)parameter);
        this.addExposedTypes(parameter.getType(), cause);
        for (Annotation annotation : parameter.getAnnotations()) {
            Class<? extends Annotation> annotationClass = annotation.annotationType();
            if (!Modifier.isPublic(annotationClass.getModifiers())) continue;
            LOG.debug("Adding exposed types from {}, which is an annotation on parameter {}", (Object)annotation, (Object)parameter);
            this.addExposedTypes(annotationClass, cause);
        }
    }

    private void addExposedTypes(Field field, Class<?> cause) {
        this.addExposedTypes(field.getGenericType(), cause);
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            LOG.debug("Adding exposed types from {}, which is an annotation on field {}", (Object)annotation, (Object)field);
            this.addExposedTypes(annotation.annotationType(), cause);
        }
    }

    private Set<Invokable> getExposedInvokables(TypeToken<?> type) {
        HashSet invokables = Sets.newHashSet();
        for (Constructor<?> constructor : type.getRawType().getConstructors()) {
            if (0 == (constructor.getModifiers() & 5)) continue;
            invokables.add(type.constructor(constructor));
        }
        for (Executable executable : type.getRawType().getMethods()) {
            if (0 == (((Method)executable).getModifiers() & 5)) continue;
            invokables.add(type.method((Method)executable));
        }
        return invokables;
    }

    private boolean exposed(int modifiers) {
        return 0 != (modifiers & 5);
    }

    private static class Matchers {
        private Matchers() {
        }

        private static class ClassesInSurfaceMatcher
        extends TypeSafeDiagnosingMatcher<ApiSurface> {
            private final Set<Matcher<Class<?>>> classMatchers;

            private ClassesInSurfaceMatcher(Set<Matcher<Class<?>>> classMatchers) {
                this.classMatchers = classMatchers;
            }

            private boolean verifyNoAbandoned(ApiSurface checkedApiSurface, Set<Matcher<Class<?>>> allowedClasses, Description mismatchDescription) {
                Function toMessage = abandonedClassMacther -> {
                    StringDescription description = new StringDescription();
                    description.appendText("No ");
                    abandonedClassMacther.describeTo((Description)description);
                    return description.toString();
                };
                Predicate matchedByExposedClasses = classMatcher -> FluentIterable.from(checkedApiSurface.getExposedClasses()).anyMatch(arg_0 -> ((Matcher)classMatcher).matches(arg_0));
                ImmutableSet matchedClassMatchers = FluentIterable.from(allowedClasses).filter(matchedByExposedClasses).toSet();
                Sets.SetView abandonedClassMatchers = Sets.difference(allowedClasses, (Set)matchedClassMatchers);
                ImmutableList messages = FluentIterable.from((Iterable)abandonedClassMatchers).transform(toMessage).toSortedList((Comparator)Ordering.natural());
                if (!messages.isEmpty()) {
                    mismatchDescription.appendText("The following allowed scopes did not have matching classes on the API surface:\n\t" + Joiner.on((String)"\n\t").join((Iterable)messages));
                }
                return messages.isEmpty();
            }

            private boolean verifyNoDisallowed(ApiSurface checkedApiSurface, Set<Matcher<Class<?>>> allowedClasses, Description mismatchDescription) {
                Function toExposure = checkedApiSurface::getAnyExposurePath;
                Maps.EntryTransformer toMessage = (aClass, exposure) -> aClass + " exposed via:\n\t\t" + Joiner.on((String)"\n\t\t").join((Iterable)exposure);
                Predicate disallowed = aClass -> !this.classIsAllowed((Class<?>)aClass, allowedClasses);
                FluentIterable disallowedClasses = FluentIterable.from(checkedApiSurface.getExposedClasses()).filter(disallowed);
                ImmutableMap exposures = Maps.toMap((Iterable)disallowedClasses, (Function)toExposure);
                ImmutableList messages = FluentIterable.from(Maps.transformEntries((Map)exposures, (Maps.EntryTransformer)toMessage).values()).toSortedList((Comparator)Ordering.natural());
                if (!messages.isEmpty()) {
                    mismatchDescription.appendText("The following disallowed classes appeared on the API surface:\n\t" + Joiner.on((String)"\n\t").join((Iterable)messages));
                }
                return messages.isEmpty();
            }

            private boolean classIsAllowed(Class<?> clazz, Set<Matcher<Class<?>>> allowedClasses) {
                return org.hamcrest.Matchers.anyOf(allowedClasses).matches(clazz);
            }

            protected boolean matchesSafely(ApiSurface apiSurface, Description mismatchDescription) {
                boolean noDisallowed = this.verifyNoDisallowed(apiSurface, this.classMatchers, mismatchDescription);
                boolean noAbandoned = this.verifyNoAbandoned(apiSurface, this.classMatchers, mismatchDescription);
                return noDisallowed && noAbandoned;
            }

            public void describeTo(Description description) {
                description.appendText("API surface to include only:\n\t");
                for (Matcher<Class<?>> classMatcher : this.classMatchers) {
                    classMatcher.describeTo(description);
                    description.appendText("\n\t");
                }
            }
        }

        private static class ClassInPackage
        extends TypeSafeDiagnosingMatcher<Class<?>> {
            private final String packageName;

            private ClassInPackage(String packageName) {
                this.packageName = packageName;
            }

            public void describeTo(Description description) {
                description.appendText("Classes in package \"");
                description.appendText(this.packageName);
                description.appendText("\"");
            }

            protected boolean matchesSafely(Class<?> clazz, Description mismatchDescription) {
                return clazz.getName().startsWith(this.packageName + ".");
            }
        }
    }
}

