/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.RowWithStorage;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;
import org.joda.time.base.AbstractInstant;

class RowUtils {
    RowUtils() {
    }

    static class CapturingRowCases
    implements RowCases {
        private final Schema topSchema;
        private final FieldOverrides fieldOverrides;

        CapturingRowCases(Schema topSchema, FieldOverrides fieldOverrides) {
            this.topSchema = topSchema;
            this.fieldOverrides = fieldOverrides;
        }

        private @Nullable FieldOverride override(RowPosition rowPosition) {
            if (!rowPosition.qualifiers.isEmpty()) {
                return null;
            }
            return this.fieldOverrides.getOverride(rowPosition.descriptor);
        }

        private <T> T overrideOrReturn(RowPosition rowPosition, T value) {
            FieldOverride fieldOverride = this.override(rowPosition);
            return (T)(fieldOverride != null ? fieldOverride.getOverrideValue() : value);
        }

        @Override
        public Row processRow(RowPosition rowPosition, Schema schema, Row value, RowFieldMatcher matcher) {
            FieldOverride override = this.override(rowPosition);
            Row retValue = value;
            if (override != null) {
                retValue = (Row)override.getOverrideValue();
            } else if (this.fieldOverrides.hasOverrideBelow(rowPosition.descriptor)) {
                ArrayList values = Lists.newArrayListWithCapacity((int)schema.getFieldCount());
                for (int i = 0; i < schema.getFieldCount(); ++i) {
                    FieldAccessDescriptor nestedDescriptor = FieldAccessDescriptor.withFieldIds(rowPosition.descriptor, i).resolve(this.topSchema);
                    Object fieldValue = value != null ? value.getValue(i) : null;
                    values.add(matcher.match(this, schema.getField(i).getType(), new RowPosition(nestedDescriptor), fieldValue));
                }
                retValue = new RowWithStorage(schema, values);
            }
            return retValue;
        }

        @Override
        public Collection<Object> processArray(RowPosition rowPosition, Schema.FieldType collectionElementType, Collection<Object> values, RowFieldMatcher matcher) {
            Collection<Object> retValue = null;
            FieldOverride override = this.override(rowPosition);
            if (override != null) {
                retValue = this.captureIterable(rowPosition, collectionElementType, (Collection)override.getOverrideValue(), matcher);
            } else if (values != null) {
                retValue = this.captureIterable(rowPosition, collectionElementType, values, matcher);
            }
            return retValue;
        }

        @Override
        public Iterable<Object> processIterable(RowPosition rowPosition, Schema.FieldType collectionElementType, Iterable<Object> values, RowFieldMatcher matcher) {
            Collection<Object> retValue = null;
            FieldOverride override = this.override(rowPosition);
            if (override != null) {
                retValue = this.captureIterable(rowPosition, collectionElementType, (Iterable)override.getOverrideValue(), matcher);
            } else if (values != null) {
                retValue = this.captureIterable(rowPosition, collectionElementType, values, matcher);
            }
            return retValue;
        }

        private Collection<Object> captureIterable(RowPosition rowPosition, Schema.FieldType collectionElementType, Iterable<Object> values, RowFieldMatcher matcher) {
            if (values == null) {
                return null;
            }
            ArrayList captured = Lists.newArrayListWithCapacity((int)Iterables.size(values));
            RowPosition elementPosition = rowPosition.withArrayQualifier();
            for (Object listValue : values) {
                if (listValue == null) {
                    if (!collectionElementType.getNullable().booleanValue()) {
                        throw new IllegalArgumentException(String.format("%s is not nullable in Array field %s", collectionElementType, rowPosition.descriptor));
                    }
                    captured.add(null);
                    continue;
                }
                Object capturedElement = matcher.match(this, collectionElementType, elementPosition, listValue);
                captured.add(capturedElement);
            }
            return captured;
        }

        @Override
        public Map<Object, Object> processMap(RowPosition rowPosition, Schema.FieldType keyType, Schema.FieldType valueType, Map<Object, Object> valueMap, RowFieldMatcher matcher) {
            HashMap retValue = null;
            FieldOverride override = this.override(rowPosition);
            if (override != null) {
                valueMap = (Map)override.getOverrideValue();
            }
            if (valueMap != null) {
                RowPosition elementPosition = rowPosition.withMapQualifier();
                retValue = Maps.newHashMapWithExpectedSize((int)valueMap.size());
                for (Map.Entry kv : valueMap.entrySet()) {
                    if (kv.getValue() == null) {
                        if (!valueType.getNullable().booleanValue()) {
                            throw new IllegalArgumentException(String.format("%s is not nullable in Map field %s", valueType, rowPosition.descriptor));
                        }
                        retValue.put(matcher.match(this, keyType, elementPosition, kv.getKey()), null);
                        continue;
                    }
                    retValue.put(matcher.match(this, keyType, elementPosition, kv.getKey()), matcher.match(this, valueType, elementPosition, kv.getValue()));
                }
            }
            return retValue;
        }

        @Override
        public Object processLogicalType(RowPosition rowPosition, Schema.LogicalType logicalType, Object value, RowFieldMatcher matcher) {
            Object retValue = null;
            FieldOverride override = this.override(rowPosition);
            if (override != null) {
                if (override.getOverrideValue() == null) {
                    return null;
                }
                retValue = logicalType.toInputType(logicalType.toBaseType(override.getOverrideValue()));
            } else if (value != null) {
                retValue = logicalType.toInputType(logicalType.toBaseType(value));
            }
            return retValue;
        }

        @Override
        public Instant processDateTime(RowPosition rowPosition, AbstractInstant value, RowFieldMatcher matcher) {
            AbstractInstant instantValue = this.overrideOrReturn(rowPosition, value);
            return instantValue != null ? instantValue.toInstant() : null;
        }

        @Override
        public Byte processByte(RowPosition rowPosition, Byte value, RowFieldMatcher matcher) {
            return this.overrideOrReturn(rowPosition, value);
        }

        @Override
        public Short processInt16(RowPosition rowPosition, Short value, RowFieldMatcher matcher) {
            return this.overrideOrReturn(rowPosition, value);
        }

        @Override
        public Integer processInt32(RowPosition rowPosition, Integer value, RowFieldMatcher matcher) {
            return this.overrideOrReturn(rowPosition, value);
        }

        @Override
        public Long processInt64(RowPosition rowPosition, Long value, RowFieldMatcher matcher) {
            return this.overrideOrReturn(rowPosition, value);
        }

        @Override
        public BigDecimal processDecimal(RowPosition rowPosition, BigDecimal value, RowFieldMatcher matcher) {
            return this.overrideOrReturn(rowPosition, value);
        }

        @Override
        public Float processFloat(RowPosition rowPosition, Float value, RowFieldMatcher matcher) {
            return this.overrideOrReturn(rowPosition, value);
        }

        @Override
        public Double processDouble(RowPosition rowPosition, Double value, RowFieldMatcher matcher) {
            return this.overrideOrReturn(rowPosition, value);
        }

        @Override
        public String processString(RowPosition rowPosition, String value, RowFieldMatcher matcher) {
            return this.overrideOrReturn(rowPosition, value);
        }

        @Override
        public Boolean processBoolean(RowPosition rowPosition, Boolean value, RowFieldMatcher matcher) {
            return this.overrideOrReturn(rowPosition, value);
        }

        @Override
        public byte[] processBytes(RowPosition rowPosition, byte[] value, RowFieldMatcher matcher) {
            byte[] retValue = this.overrideOrReturn(rowPosition, value);
            return retValue instanceof ByteBuffer ? ((ByteBuffer)retValue).array() : retValue;
        }
    }

    static class FieldOverrides {
        private FieldAccessNode topNode;
        private Schema rootSchema;

        FieldOverrides(Schema rootSchema) {
            this.topNode = new FieldAccessNode(rootSchema);
            this.rootSchema = rootSchema;
        }

        FieldOverrides(Schema rootSchema, List<Object> overrides) {
            this.topNode = new FieldAccessNode(rootSchema, overrides);
            this.rootSchema = rootSchema;
        }

        boolean isEmpty() {
            return this.topNode.isEmpty();
        }

        void addOverride(FieldAccessDescriptor fieldAccessDescriptor, FieldOverride fieldOverride) {
            this.topNode.addOverride(fieldAccessDescriptor, fieldOverride, this.rootSchema);
        }

        void setOverrides(List<Object> values) {
            ArrayList overrides = Lists.newArrayListWithExpectedSize((int)values.size());
            for (Object value : values) {
                overrides.add(new FieldOverride(value));
            }
            this.topNode.setOverrides(overrides);
        }

        @Nullable FieldOverride getOverride(FieldAccessDescriptor fieldAccessDescriptor) {
            return this.topNode.getOverride(fieldAccessDescriptor);
        }

        boolean hasOverrideBelow(FieldAccessDescriptor fieldAccessDescriptor) {
            return this.topNode.hasOverrideBelow(fieldAccessDescriptor);
        }

        private static class FieldAccessNode {
            List<FieldOverride> fieldOverrides;
            List<FieldAccessNode> nestedAccess;

            FieldAccessNode(Schema schema) {
                this.fieldOverrides = Lists.newArrayListWithExpectedSize((int)schema.getFieldCount());
                this.nestedAccess = Lists.newArrayList();
            }

            FieldAccessNode(Schema schema, List<Object> overrides) {
                this.fieldOverrides = Lists.newArrayListWithExpectedSize((int)schema.getFieldCount());
                for (Object value : overrides) {
                    this.fieldOverrides.add(new FieldOverride(value));
                }
                this.nestedAccess = Lists.newArrayList();
            }

            boolean isEmpty() {
                return this.fieldOverrides.isEmpty() && this.nestedAccess.isEmpty();
            }

            void addOverride(FieldAccessDescriptor fieldAccessDescriptor, FieldOverride fieldOverride, Schema currentSchema) {
                if (!fieldAccessDescriptor.getFieldsAccessed().isEmpty()) {
                    FieldAccessDescriptor.FieldDescriptor fieldDescriptor = (FieldAccessDescriptor.FieldDescriptor)Iterables.getOnlyElement(fieldAccessDescriptor.getFieldsAccessed());
                    int aheadPosition = fieldDescriptor.getFieldId() - this.fieldOverrides.size() + 1;
                    if (aheadPosition > 0) {
                        this.fieldOverrides.addAll(Collections.nCopies(aheadPosition, null));
                    }
                    this.fieldOverrides.set(fieldDescriptor.getFieldId(), fieldOverride);
                } else if (!fieldAccessDescriptor.getNestedFieldsAccessed().isEmpty()) {
                    Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(fieldAccessDescriptor.getNestedFieldsAccessed().entrySet());
                    int aheadPosition = ((FieldAccessDescriptor.FieldDescriptor)entry.getKey()).getFieldId() - this.nestedAccess.size() + 1;
                    if (aheadPosition > 0) {
                        this.nestedAccess.addAll(Collections.nCopies(aheadPosition, null));
                    }
                    Schema nestedSchema = currentSchema.getField(((FieldAccessDescriptor.FieldDescriptor)entry.getKey()).getFieldId()).getType().getRowSchema();
                    FieldAccessNode node = this.nestedAccess.get(((FieldAccessDescriptor.FieldDescriptor)entry.getKey()).getFieldId());
                    if (node == null) {
                        node = new FieldAccessNode(nestedSchema);
                        this.nestedAccess.set(((FieldAccessDescriptor.FieldDescriptor)entry.getKey()).getFieldId(), node);
                    }
                    node.addOverride((FieldAccessDescriptor)entry.getValue(), fieldOverride, nestedSchema);
                }
            }

            void setOverrides(List<FieldOverride> overrides) {
                this.fieldOverrides = overrides;
            }

            @Nullable FieldOverride getOverride(FieldAccessDescriptor fieldAccessDescriptor) {
                FieldAccessNode node;
                Map.Entry entry;
                FieldOverride override = null;
                if (!fieldAccessDescriptor.getFieldsAccessed().isEmpty()) {
                    FieldAccessDescriptor.FieldDescriptor fieldDescriptor = (FieldAccessDescriptor.FieldDescriptor)Iterables.getOnlyElement(fieldAccessDescriptor.getFieldsAccessed());
                    if (fieldDescriptor.getFieldId() < this.fieldOverrides.size()) {
                        override = this.fieldOverrides.get(fieldDescriptor.getFieldId());
                    }
                } else if (!fieldAccessDescriptor.getNestedFieldsAccessed().isEmpty() && ((FieldAccessDescriptor.FieldDescriptor)(entry = (Map.Entry)Iterables.getOnlyElement(fieldAccessDescriptor.getNestedFieldsAccessed().entrySet())).getKey()).getFieldId() < this.nestedAccess.size() && (node = this.nestedAccess.get(((FieldAccessDescriptor.FieldDescriptor)entry.getKey()).getFieldId())) != null) {
                    override = node.getOverride((FieldAccessDescriptor)entry.getValue());
                }
                return override;
            }

            boolean hasOverrideBelow(FieldAccessDescriptor fieldAccessDescriptor) {
                if (!fieldAccessDescriptor.getFieldsAccessed().isEmpty()) {
                    FieldAccessDescriptor.FieldDescriptor fieldDescriptor = (FieldAccessDescriptor.FieldDescriptor)Iterables.getOnlyElement(fieldAccessDescriptor.getFieldsAccessed());
                    return fieldDescriptor.getFieldId() < this.nestedAccess.size() && this.nestedAccess.get(fieldDescriptor.getFieldId()) != null;
                }
                if (!fieldAccessDescriptor.getNestedFieldsAccessed().isEmpty()) {
                    FieldAccessNode node;
                    Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(fieldAccessDescriptor.getNestedFieldsAccessed().entrySet());
                    if (((FieldAccessDescriptor.FieldDescriptor)entry.getKey()).getFieldId() < this.nestedAccess.size() && (node = this.nestedAccess.get(((FieldAccessDescriptor.FieldDescriptor)entry.getKey()).getFieldId())) != null) {
                        return node.hasOverrideBelow((FieldAccessDescriptor)entry.getValue());
                    }
                } else {
                    return true;
                }
                return false;
            }
        }
    }

    static class FieldOverride {
        final Object overrideValue;

        FieldOverride(Object overrideValue) {
            this.overrideValue = overrideValue;
        }

        Object getOverrideValue() {
            return this.overrideValue;
        }
    }

    static class RowFieldMatcher {
        RowFieldMatcher() {
        }

        public Object match(RowCases cases, Schema.FieldType fieldType, RowPosition rowPosition, Object value) {
            Object processedValue = null;
            switch (fieldType.getTypeName()) {
                case ARRAY: {
                    processedValue = cases.processArray(rowPosition, fieldType.getCollectionElementType(), (Collection)value, this);
                    break;
                }
                case ITERABLE: {
                    processedValue = cases.processIterable(rowPosition, fieldType.getCollectionElementType(), (Iterable)value, this);
                    break;
                }
                case MAP: {
                    processedValue = cases.processMap(rowPosition, fieldType.getMapKeyType(), fieldType.getMapValueType(), (Map)value, this);
                    break;
                }
                case ROW: {
                    processedValue = cases.processRow(rowPosition, fieldType.getRowSchema(), (Row)value, this);
                    break;
                }
                case LOGICAL_TYPE: {
                    Schema.LogicalType logicalType = fieldType.getLogicalType();
                    processedValue = cases.processLogicalType(rowPosition, logicalType, value, this);
                    break;
                }
                case DATETIME: {
                    processedValue = cases.processDateTime(rowPosition, (AbstractInstant)value, this);
                    break;
                }
                case BYTE: {
                    processedValue = cases.processByte(rowPosition, (Byte)value, this);
                    break;
                }
                case BYTES: {
                    processedValue = cases.processBytes(rowPosition, (byte[])value, this);
                    break;
                }
                case INT16: {
                    processedValue = cases.processInt16(rowPosition, (Short)value, this);
                    break;
                }
                case INT32: {
                    processedValue = cases.processInt32(rowPosition, (Integer)value, this);
                    break;
                }
                case INT64: {
                    processedValue = cases.processInt64(rowPosition, (Long)value, this);
                    break;
                }
                case DECIMAL: {
                    processedValue = cases.processDecimal(rowPosition, (BigDecimal)value, this);
                    break;
                }
                case FLOAT: {
                    processedValue = cases.processFloat(rowPosition, (Float)value, this);
                    break;
                }
                case DOUBLE: {
                    processedValue = cases.processDouble(rowPosition, (Double)value, this);
                    break;
                }
                case STRING: {
                    processedValue = cases.processString(rowPosition, (String)value, this);
                    break;
                }
                case BOOLEAN: {
                    processedValue = cases.processBoolean(rowPosition, (Boolean)value, this);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Not a primitive type for field name %s: %s", rowPosition.descriptor, fieldType));
                }
            }
            if (processedValue == null && !fieldType.getNullable().booleanValue()) {
                throw new IllegalArgumentException(String.format("%s is not nullable in  field %s", fieldType, rowPosition.descriptor));
            }
            return processedValue;
        }
    }

    static interface RowCases {
        public Row processRow(RowPosition var1, Schema var2, Row var3, RowFieldMatcher var4);

        public Collection<Object> processArray(RowPosition var1, Schema.FieldType var2, Collection<Object> var3, RowFieldMatcher var4);

        public Iterable<Object> processIterable(RowPosition var1, Schema.FieldType var2, Iterable<Object> var3, RowFieldMatcher var4);

        public Map<Object, Object> processMap(RowPosition var1, Schema.FieldType var2, Schema.FieldType var3, Map<Object, Object> var4, RowFieldMatcher var5);

        public Object processLogicalType(RowPosition var1, Schema.LogicalType var2, Object var3, RowFieldMatcher var4);

        public Instant processDateTime(RowPosition var1, AbstractInstant var2, RowFieldMatcher var3);

        public Byte processByte(RowPosition var1, Byte var2, RowFieldMatcher var3);

        public Short processInt16(RowPosition var1, Short var2, RowFieldMatcher var3);

        public Integer processInt32(RowPosition var1, Integer var2, RowFieldMatcher var3);

        public Long processInt64(RowPosition var1, Long var2, RowFieldMatcher var3);

        public BigDecimal processDecimal(RowPosition var1, BigDecimal var2, RowFieldMatcher var3);

        public Float processFloat(RowPosition var1, Float var2, RowFieldMatcher var3);

        public Double processDouble(RowPosition var1, Double var2, RowFieldMatcher var3);

        public String processString(RowPosition var1, String var2, RowFieldMatcher var3);

        public Boolean processBoolean(RowPosition var1, Boolean var2, RowFieldMatcher var3);

        public byte[] processBytes(RowPosition var1, byte[] var2, RowFieldMatcher var3);
    }

    static class RowPosition {
        FieldAccessDescriptor descriptor;
        List<FieldAccessDescriptor.FieldDescriptor.Qualifier> qualifiers;

        RowPosition(FieldAccessDescriptor descriptor) {
            this(descriptor, Collections.emptyList());
        }

        RowPosition(FieldAccessDescriptor descriptor, List<FieldAccessDescriptor.FieldDescriptor.Qualifier> qualifiers) {
            this.descriptor = descriptor;
            this.qualifiers = qualifiers;
        }

        RowPosition withArrayQualifier() {
            ArrayList newQualifiers = Lists.newArrayListWithCapacity((int)(this.qualifiers.size() + 1));
            newQualifiers.addAll(this.qualifiers);
            newQualifiers.add(FieldAccessDescriptor.FieldDescriptor.Qualifier.of(FieldAccessDescriptor.FieldDescriptor.ListQualifier.ALL));
            return new RowPosition(this.descriptor, newQualifiers);
        }

        RowPosition withMapQualifier() {
            ArrayList newQualifiers = Lists.newArrayListWithCapacity((int)(this.qualifiers.size() + 1));
            newQualifiers.addAll(this.qualifiers);
            newQualifiers.add(FieldAccessDescriptor.FieldDescriptor.Qualifier.of(FieldAccessDescriptor.FieldDescriptor.MapQualifier.ALL));
            return new RowPosition(this.descriptor, newQualifiers);
        }
    }
}

