/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.core.value;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.ValueDataUtil;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaPlugin;
import org.apache.hop.neo4j.core.data.GraphData;
import org.w3c.dom.Node;

@ValueMetaPlugin(id="303", name="Graph", description="Graph data type containing nodes, relationships and their properties")
public class ValueMetaGraph
extends ValueMetaBase
implements IValueMeta {
    public static final int TYPE_GRAPH = 303;

    public ValueMetaGraph() {
        super(null, 303);
    }

    public ValueMetaGraph(String name) {
        super(name, 303);
    }

    public ValueMetaGraph(Node node) throws HopException {
        super(node);
    }

    public Object getNativeDataType(Object object) throws HopValueException {
        return this.getGraphData(object);
    }

    public GraphData getGraphData(Object object) throws HopValueException {
        switch (this.type) {
            case 303: {
                switch (this.storageType) {
                    case 0: {
                        return (GraphData)object;
                    }
                }
                throw new HopValueException("Only normal storage type is supported for Graph value : " + this.toString());
            }
            case 2: {
                switch (this.storageType) {
                    case 0: {
                        try {
                            return new GraphData((String)object);
                        }
                        catch (Exception e) {
                            throw new HopValueException("Error converting a JSON representation of Graph value data to a native representation", (Throwable)e);
                        }
                    }
                }
                throw new HopValueException("Only normal storage type is supported for Graph value : " + this.toString());
            }
        }
        throw new HopValueException("Unable to convert data type " + this.toString() + " to Graph value");
    }

    public String getString(Object object) throws HopValueException {
        try {
            String string;
            block1 : switch (this.type) {
                case 2: {
                    switch (this.storageType) {
                        case 0: {
                            string = object == null ? null : object.toString();
                            break;
                        }
                        case 1: {
                            string = (String)this.convertBinaryStringToNativeType((byte[])object);
                            break;
                        }
                        case 2: {
                            string = object == null ? null : (String)this.index[(Integer)object];
                            break;
                        }
                        default: {
                            throw new HopValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                        }
                    }
                    if (string == null) break;
                    string = this.trim(string);
                    break;
                }
                case 3: {
                    throw new HopValueException("You can't convert a Date to a Graph data type for : " + this.toString());
                }
                case 1: {
                    throw new HopValueException("You can't convert a Number to a Graph data type for : " + this.toString());
                }
                case 5: {
                    throw new HopValueException("You can't convert an Integer to a Graph data type for : " + this.toString());
                }
                case 6: {
                    throw new HopValueException("You can't convert a BigNumber to a Graph data type for : " + this.toString());
                }
                case 4: {
                    throw new HopValueException("You can't convert a Boolean to a Graph data type for : " + this.toString());
                }
                case 8: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertBinaryStringToString((byte[])object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertBinaryStringToString((byte[])object);
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertBinaryStringToString((byte[])this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new HopValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 7: {
                    switch (this.storageType) {
                        case 0: {
                            string = object == null ? null : object.toString();
                            break block1;
                        }
                        case 1: {
                            string = this.convertBinaryStringToString((byte[])object);
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.index[(Integer)object].toString();
                            break block1;
                        }
                    }
                    throw new HopValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 303: {
                    switch (this.storageType) {
                        case 0: {
                            string = object == null ? null : ((GraphData)object).toJsonString();
                            break block1;
                        }
                    }
                    throw new HopValueException(this.toString() + " : Unsupported storage type " + this.getStorageTypeDesc() + " for " + this.toString());
                }
                default: {
                    throw new HopValueException(this.toString() + " : Unknown type " + this.type + " specified.");
                }
            }
            if (this.isOutputPaddingEnabled() && this.getLength() > 0) {
                string = ValueDataUtil.rightPad((String)string, (int)this.getLength());
            }
            return string;
        }
        catch (ClassCastException e) {
            throw new HopValueException(this.toString() + " : There was a data type error: the data type of " + object.getClass().getName() + " object [" + object + "] does not correspond to value meta [" + this.toStringMeta() + "]");
        }
    }

    public Object cloneValueData(Object object) throws HopValueException {
        if (object == null) {
            return null;
        }
        GraphData graphData = this.getGraphData(object);
        return new GraphData(graphData);
    }

    public Class<?> getNativeDataTypeClass() throws HopValueException {
        return GraphData.class;
    }
}

