/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.lifecycle;

import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.lifecycle.ProjectLifecycle;
import picocli.CommandLine;

public class ManageLifecyclesOptionPlugin
implements IConfigOptions {
    @CommandLine.Option(names={"-lc", "--lifecycle-create"}, description={"Create a new project lifecycle. You need so specify a name and one or more lifecycle environments and configuration files."})
    private boolean createLifecycle;
    @CommandLine.Option(names={"-l", "--lifecycle"}, description={"The name of the lifecycle to manage"})
    private String lifecycleName;
    @CommandLine.Option(names={"-le", "--lifecycle-environments"}, description={"The names of the lifecycle environments, comma separated"}, split=",")
    private String[] lifecycleEnvironments;
    @CommandLine.Option(names={"-cf", "--config-files"}, description={"The file names of the lifecycle configuration files, comma separated"}, split=",")
    private String[] configFilenames;
    @CommandLine.Option(names={"-lm", "--lifecycle-modify"}, description={"Modify a lifecycle"})
    private boolean modifyLifecycle;
    @CommandLine.Option(names={"-ld", "--lifecycle-delete"}, description={"Delete a lifecycle"})
    private boolean deleteLifecycle;
    @CommandLine.Option(names={"-ll", "-lifecycles-list"}, description={"List the defined lifecycles"})
    private boolean listLifecycles;

    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider hasHopMetadataProvider, IVariables variables) throws HopException {
        try {
            boolean changed = false;
            if (this.createLifecycle) {
                this.createLifecycle(log);
                changed = true;
            } else if (this.modifyLifecycle) {
                this.modifyLifecycle(log);
                changed = true;
            } else if (this.deleteLifecycle) {
                this.deleteLifecycle(log);
                changed = true;
            } else if (this.listLifecycles) {
                this.listLifecycles(log);
                changed = true;
            }
            return changed;
        }
        catch (Exception e) {
            throw new HopException("Error handling lifecycle configuration options", (Throwable)e);
        }
    }

    private void listLifecycles(ILogChannel log) throws HopException {
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        log.logBasic("Project lifecycles:");
        List<String> names = config.listLifecycleNames();
        for (String name : names) {
            ProjectLifecycle lifecycle = config.findLifecycle(name);
            this.logLifecycleDetails(log, lifecycle);
        }
    }

    private void logLifecycleDetails(ILogChannel log, ProjectLifecycle lifecycle) {
        log.logBasic("  Name : " + lifecycle.getName());
        log.logBasic("    Project lifecycle environments:");
        for (String environmentName : lifecycle.getLifecycleEnvironments()) {
            log.logBasic("      " + environmentName);
        }
        log.logBasic("    Configuration files:");
        for (String configurationFile : lifecycle.getConfigurationFiles()) {
            log.logBasic("      " + configurationFile);
        }
    }

    private void deleteLifecycle(ILogChannel log) throws Exception {
        this.validateLifecycleNameSpecified();
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        this.validateLifecycleNameSpecified();
        ProjectLifecycle lifecycle = config.findLifecycle(this.lifecycleName);
        if (lifecycle == null) {
            throw new HopException("Project lifecycle '" + this.lifecycleName + "' doesn't exist, it can't be deleted");
        }
        config.removeLifecycle(this.lifecycleName);
        HopConfig.getInstance().saveToFile();
        log.logBasic("Project lifecycle '" + this.lifecycleName + "' was delete.");
    }

    private void modifyLifecycle(ILogChannel log) throws Exception {
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        this.validateLifecycleNameSpecified();
        ProjectLifecycle lifecycle = config.findLifecycle(this.lifecycleName);
        if (lifecycle == null) {
            throw new HopException("Project lifecycle '" + this.lifecycleName + "' doesn't exist, it can't be modified");
        }
        if (this.lifecycleEnvironments != null) {
            lifecycle.getLifecycleEnvironments().clear();
            lifecycle.getLifecycleEnvironments().addAll(Arrays.asList(this.lifecycleEnvironments));
        }
        if (this.configFilenames != null) {
            lifecycle.getConfigurationFiles().clear();
            lifecycle.getConfigurationFiles().addAll(Arrays.asList(this.configFilenames));
        }
        config.addLifecycle(lifecycle);
        HopConfig.getInstance().saveToFile();
        log.logBasic("Project lifecycle '" + this.lifecycleName + "' was modified.");
        log.logBasic("Details after changes:");
        this.logLifecycleDetails(log, lifecycle);
    }

    private void createLifecycle(ILogChannel log) throws Exception {
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        this.validateLifecycleNameSpecified();
        log.logBasic("Creating project lifecycle '" + this.lifecycleName + "'");
        ProjectLifecycle lifecycle = config.findLifecycle(this.lifecycleName);
        if (lifecycle != null) {
            throw new HopException("Project lifecycle '" + this.lifecycleName + "' already exists.");
        }
        lifecycle = new ProjectLifecycle();
        lifecycle.setName(this.lifecycleName);
        if (this.lifecycleEnvironments != null) {
            lifecycle.getLifecycleEnvironments().addAll(Arrays.asList(this.lifecycleEnvironments));
        }
        if (this.configFilenames != null) {
            lifecycle.getConfigurationFiles().addAll(Arrays.asList(this.configFilenames));
        }
        config.addLifecycle(lifecycle);
        HopConfig.getInstance().saveToFile();
        log.logBasic("Project lifecycle '" + this.lifecycleName + "' was created.");
        log.logBasic("Details after creation:");
        this.logLifecycleDetails(log, lifecycle);
    }

    private void validateLifecycleNameSpecified() throws Exception {
        if (StringUtil.isEmpty((String)this.lifecycleName)) {
            throw new HopException("Please specify the name of the lifecycle");
        }
    }
}

