/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.Printer;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.AbstractVAction;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VObject;

class PrinterAvailableAction
extends AbstractVAction {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String displayName_ = ResourceLoader.getText("ACTION_AVAILABLE");
    private Printer printer_ = null;

    public PrinterAvailableAction(VObject vObject, Printer printer) {
        super(vObject);
        this.printer_ = printer;
    }

    public String getText() {
        return displayName_;
    }

    public void perform(VActionContext vActionContext) {
        try {
            this.fireStartWorking();
            CommandCall commandCall = new CommandCall(this.printer_.getSystem());
            String string = "VRYCFG CFGOBJ(" + this.printer_.getName() + ") ";
            string = string + "CFGTYPE(*DEV) STATUS(*ON) RANGE(*OBJ)";
            try {
                if (!commandCall.run(string)) {
                    if (Trace.isTraceOn()) {
                        Trace.log(2, "ERROR VRYCFG cmd for [" + this.printer_.getName() + "].");
                    }
                    Exception exception = new Exception(ResourceLoader.getText("EXC_AS400_ERROR"));
                    this.fireError(exception);
                } else {
                    if (Trace.isTraceOn()) {
                        Trace.log(3, "Varied On printer [" + this.printer_.getName() + "].");
                    }
                    this.fireObjectChanged();
                }
                if (Trace.isTraceOn()) {
                    AS400Message[] aS400MessageArray = commandCall.getMessageList();
                    for (int i = 0; i < aS400MessageArray.length; ++i) {
                        Trace.log(3, aS400MessageArray[i].getText());
                    }
                }
            }
            catch (Exception exception) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "ERROR CommandCall exception for [" + this.printer_.getName() + "].");
                }
                this.fireError(exception);
            }
            this.fireStopWorking();
        }
        catch (Exception exception) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "ERROR Varied On printer [" + this.printer_.getName() + "].");
            }
            this.fireError(exception);
        }
    }
}

