/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.i18n.BaseMessages;

public class CheckResult
implements ICheckResult {
    private static final Class<?> PKG = Const.class;
    public static final String[] typeDesc = new String[]{"", BaseMessages.getString(PKG, "CheckResult.OK", new String[0]), BaseMessages.getString(PKG, "CheckResult.Remark", new String[0]), BaseMessages.getString(PKG, "CheckResult.Warning", new String[0]), BaseMessages.getString(PKG, "CheckResult.Error", new String[0])};
    private int type;
    private String text;
    private ICheckResultSource sourceMeta;
    private String errorCode;

    public CheckResult() {
        this(0, "", null);
    }

    public CheckResult(int t, String s, ICheckResultSource sourceMeta) {
        this.type = t;
        this.text = s;
        this.sourceMeta = sourceMeta;
    }

    public CheckResult(int t, String errorCode, String s, ICheckResultSource sourceMeta) {
        this(t, s, sourceMeta);
        this.errorCode = errorCode;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getTypeDesc() {
        return typeDesc[this.type];
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public ICheckResultSource getSourceInfo() {
        return this.sourceMeta;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(typeDesc[this.type]).append(": ").append(this.text);
        if (this.sourceMeta != null) {
            sb.append(" (").append(this.sourceMeta.getName()).append(")");
        }
        return sb.toString();
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public void setText(String value) {
        this.text = value;
    }

    @Override
    public void setType(int value) {
        this.type = value;
    }
}

