/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui.plugin;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.gui.plugin.BaseGuiElements;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.gui.plugin.ITypeFilename;
import org.apache.hop.core.gui.plugin.ITypeMetadata;
import org.apache.hop.core.util.StringUtil;

public class GuiElements
extends BaseGuiElements
implements Comparable<GuiElements> {
    private String id;
    private String order;
    private String parentId;
    private String label;
    private String toolTip;
    private GuiElementType type;
    private String image;
    private String disabledImage;
    private boolean variablesEnabled;
    private boolean password;
    private String fieldName;
    private Class<?> fieldClass;
    private String getterMethod;
    private String setterMethod;
    private String getComboValuesMethod;
    private List<GuiElements> children = new ArrayList<GuiElements>();
    private boolean ignored;
    private boolean addingSeparator;
    private ClassLoader classLoader;
    private boolean singleTon;
    private Class<?> listenerClass;
    private String listenerMethod;
    private Class<? extends ITypeFilename> typeFilename;
    private Class<? extends ITypeMetadata> typeMetadata;
    private Method buttonMethod;

    public GuiElements() {
    }

    public GuiElements(GuiWidgetElement guiElement, Field field) {
        this();
        String fieldName = field.getName();
        Class<?> fieldClass = field.getType();
        String fieldPackageName = field.getDeclaringClass().getPackage().getName();
        this.id = StringUtil.isEmpty(guiElement.id()) ? field.getName() : guiElement.id();
        this.order = guiElement.order();
        this.type = guiElement.type();
        this.parentId = guiElement.parentId();
        this.fieldName = fieldName;
        this.fieldClass = fieldClass;
        this.getterMethod = this.calculateGetterMethod(guiElement, fieldName);
        this.setterMethod = this.calculateSetterMethod(guiElement, fieldName);
        this.getComboValuesMethod = guiElement.comboValuesMethod();
        this.image = guiElement.image();
        this.disabledImage = null;
        this.variablesEnabled = guiElement.variables();
        this.password = guiElement.password();
        this.ignored = guiElement.ignored();
        this.addingSeparator = guiElement.separator();
        this.label = this.getTranslation(guiElement.label(), fieldPackageName, field.getDeclaringClass());
        this.toolTip = this.getTranslation(guiElement.toolTip(), fieldPackageName, field.getDeclaringClass());
        this.typeFilename = guiElement.typeFilename();
        this.typeMetadata = guiElement.typeMetadata();
        this.buttonMethod = null;
    }

    public GuiElements(GuiWidgetElement guiElement, Method method, ClassLoader classLoader) {
        this();
        Class<?> methodClass = method.getDeclaringClass();
        String methodPackageName = methodClass.getPackage().getName();
        this.id = StringUtil.isEmpty(guiElement.id()) ? method.getName() : guiElement.id();
        this.order = guiElement.order();
        this.type = guiElement.type();
        this.parentId = guiElement.parentId();
        this.fieldName = null;
        this.fieldClass = null;
        this.getterMethod = null;
        this.setterMethod = null;
        this.getComboValuesMethod = guiElement.comboValuesMethod();
        this.image = guiElement.image();
        this.disabledImage = null;
        this.variablesEnabled = guiElement.variables();
        this.password = guiElement.password();
        this.ignored = guiElement.ignored();
        this.addingSeparator = guiElement.separator();
        this.label = this.getTranslation(guiElement.label(), methodPackageName, method.getDeclaringClass());
        this.toolTip = this.getTranslation(guiElement.toolTip(), methodPackageName, method.getDeclaringClass());
        this.typeFilename = guiElement.typeFilename();
        this.typeMetadata = guiElement.typeMetadata();
        this.classLoader = classLoader;
        this.buttonMethod = method;
    }

    public void sortChildren() {
        Collections.sort(this.children);
    }

    public GuiElements findChild(String id) {
        for (GuiElements child : this.children) {
            if (child.getId() == null || !child.getId().equals(id)) continue;
            return child;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuiElements that = (GuiElements)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public int compareTo(GuiElements e) {
        if (StringUtils.isNotEmpty((String)this.order) && StringUtils.isNotEmpty((String)e.id)) {
            return this.order.compareTo(e.order);
        }
        return this.id.compareTo(e.id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    public GuiElementType getType() {
        return this.type;
    }

    public void setType(GuiElementType type) {
        this.type = type;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getDisabledImage() {
        return this.disabledImage;
    }

    public void setDisabledImage(String disabledImage) {
        this.disabledImage = disabledImage;
    }

    public List<GuiElements> getChildren() {
        return this.children;
    }

    public void setChildren(List<GuiElements> children) {
        this.children = children;
    }

    public boolean isVariablesEnabled() {
        return this.variablesEnabled;
    }

    public void setVariablesEnabled(boolean variablesEnabled) {
        this.variablesEnabled = variablesEnabled;
    }

    public boolean isPassword() {
        return this.password;
    }

    public void setPassword(boolean password) {
        this.password = password;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getGetterMethod() {
        return this.getterMethod;
    }

    public void setGetterMethod(String getterMethod) {
        this.getterMethod = getterMethod;
    }

    public String getSetterMethod() {
        return this.setterMethod;
    }

    public void setSetterMethod(String setterMethod) {
        this.setterMethod = setterMethod;
    }

    public String getGetComboValuesMethod() {
        return this.getComboValuesMethod;
    }

    public void setGetComboValuesMethod(String getComboValuesMethod) {
        this.getComboValuesMethod = getComboValuesMethod;
    }

    public Class<?> getFieldClass() {
        return this.fieldClass;
    }

    public void setFieldClass(Class<?> fieldClass) {
        this.fieldClass = fieldClass;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    public boolean isAddingSeparator() {
        return this.addingSeparator;
    }

    public void setAddingSeparator(boolean addingSeparator) {
        this.addingSeparator = addingSeparator;
    }

    public Class<?> getListenerClass() {
        return this.listenerClass;
    }

    public void setListenerClass(Class<?> listenerClass) {
        this.listenerClass = listenerClass;
    }

    public String getListenerMethod() {
        return this.listenerMethod;
    }

    public void setListenerMethod(String listenerMethod) {
        this.listenerMethod = listenerMethod;
    }

    public boolean isSingleTon() {
        return this.singleTon;
    }

    public void setSingleTon(boolean singleTon) {
        this.singleTon = singleTon;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Class<? extends ITypeFilename> getTypeFilename() {
        return this.typeFilename;
    }

    public void setTypeFilename(Class<? extends ITypeFilename> typeFilename) {
        this.typeFilename = typeFilename;
    }

    public Class<? extends ITypeMetadata> getTypeMetadata() {
        return this.typeMetadata;
    }

    public void setTypeMetadata(Class<? extends ITypeMetadata> typeMetadata) {
        this.typeMetadata = typeMetadata;
    }

    public Method getButtonMethod() {
        return this.buttonMethod;
    }

    public void setButtonMethod(Method buttonMethod) {
        this.buttonMethod = buttonMethod;
    }
}

