/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.core.Concatenate;
import org.apache.beam.runners.core.construction.CreatePCollectionViewTranslation;
import org.apache.beam.runners.core.construction.ReplacementOutputs;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

class CreateStreamingFlinkView<ElemT, ViewT>
extends PTransform<PCollection<ElemT>, PCollection<ElemT>> {
    private final PCollectionView<ViewT> view;
    public static final String CREATE_STREAMING_FLINK_VIEW_URN = "beam:transform:flink:create-streaming-flink-view:v1";

    public CreateStreamingFlinkView(PCollectionView<ViewT> view) {
        this.view = view;
    }

    public PCollection<ElemT> expand(PCollection<ElemT> input) {
        ((PCollection)input.apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new Concatenate()).withoutDefaults())).apply(CreateFlinkPCollectionView.of(this.view));
        return input;
    }

    public static class Factory<ElemT, ViewT>
    implements PTransformOverrideFactory<PCollection<ElemT>, PCollection<ElemT>, PTransform<PCollection<ElemT>, PCollection<ElemT>>> {
        static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PCollection<ElemT>, PCollection<ElemT>> getReplacementTransform(AppliedPTransform<PCollection<ElemT>, PCollection<ElemT>, PTransform<PCollection<ElemT>, PCollection<ElemT>>> transform) {
            PCollectionView view;
            PCollection collection = (PCollection)Iterables.getOnlyElement(transform.getInputs().values());
            try {
                view = CreatePCollectionViewTranslation.getView(transform);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            CreateStreamingFlinkView createFlinkView = new CreateStreamingFlinkView(view);
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)collection, createFlinkView);
        }

        public Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PCollection<?>> outputs, PCollection<ElemT> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    public static class CreateFlinkPCollectionView<ElemT, ViewT>
    extends PTransform<PCollection<List<ElemT>>, PCollection<List<ElemT>>> {
        private PCollectionView<ViewT> view;

        private CreateFlinkPCollectionView(PCollectionView<ViewT> view) {
            this.view = view;
        }

        public static <ElemT, ViewT> CreateFlinkPCollectionView<ElemT, ViewT> of(PCollectionView<ViewT> view) {
            return new CreateFlinkPCollectionView<ElemT, ViewT>(view);
        }

        public PCollection<List<ElemT>> expand(PCollection<List<ElemT>> input) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)input.getWindowingStrategy(), (PCollection.IsBounded)input.isBounded(), (Coder)input.getCoder());
        }

        public PCollectionView<ViewT> getView() {
            return this.view;
        }
    }
}

