/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.util.Map;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.translation.functions.AbstractFlinkCombineRunner;
import org.apache.beam.runners.flink.translation.functions.FlinkSideInputReader;
import org.apache.beam.runners.flink.translation.functions.HashingFlinkCombineRunner;
import org.apache.beam.runners.flink.translation.functions.SingleWindowFlinkCombineRunner;
import org.apache.beam.runners.flink.translation.functions.SortingFlinkCombineRunner;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;

public class FlinkReduceFunction<K, AccumT, OutputT, W extends BoundedWindow>
extends RichGroupReduceFunction<WindowedValue<KV<K, AccumT>>, WindowedValue<KV<K, OutputT>>> {
    protected final CombineFnBase.GlobalCombineFn<?, AccumT, OutputT> combineFn;
    protected final WindowingStrategy<Object, W> windowingStrategy;
    protected final Map<PCollectionView<?>, WindowingStrategy<?, ?>> sideInputs;
    protected final SerializablePipelineOptions serializedOptions;
    private final boolean groupedByWindow;

    public FlinkReduceFunction(CombineFnBase.GlobalCombineFn<?, AccumT, OutputT> combineFn, WindowingStrategy<Object, W> windowingStrategy, Map<PCollectionView<?>, WindowingStrategy<?, ?>> sideInputs, PipelineOptions pipelineOptions) {
        this(combineFn, windowingStrategy, sideInputs, pipelineOptions, false);
    }

    public FlinkReduceFunction(CombineFnBase.GlobalCombineFn<?, AccumT, OutputT> combineFn, WindowingStrategy<Object, W> windowingStrategy, Map<PCollectionView<?>, WindowingStrategy<?, ?>> sideInputs, PipelineOptions pipelineOptions, boolean groupedByWindow) {
        this.combineFn = combineFn;
        this.windowingStrategy = windowingStrategy;
        this.sideInputs = sideInputs;
        this.serializedOptions = new SerializablePipelineOptions(pipelineOptions);
        this.groupedByWindow = groupedByWindow;
    }

    public void open(Configuration parameters) {
        FileSystems.setDefaultPipelineOptions((PipelineOptions)this.serializedOptions.get());
    }

    public void reduce(Iterable<WindowedValue<KV<K, AccumT>>> elements, Collector<WindowedValue<KV<K, OutputT>>> out) throws Exception {
        PipelineOptions options = this.serializedOptions.get();
        FlinkSideInputReader sideInputReader = new FlinkSideInputReader(this.sideInputs, this.getRuntimeContext());
        AbstractFlinkCombineRunner reduceRunner = this.groupedByWindow ? new SingleWindowFlinkCombineRunner() : (this.windowingStrategy.needsMerge() && this.windowingStrategy.getWindowFn() instanceof Sessions ? new SortingFlinkCombineRunner() : new HashingFlinkCombineRunner());
        ((AbstractFlinkCombineRunner)reduceRunner).combine(new AbstractFlinkCombineRunner.FinalFlinkCombiner(this.combineFn), this.windowingStrategy, sideInputReader, options, elements, out);
    }
}

