/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.runners.core.KeyedWorkItem;
import org.apache.beam.runners.flink.translation.wrappers.streaming.SingletonKeyedWorkItem;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

public class SingletonKeyedWorkItemCoder<K, ElemT>
extends StructuredCoder<KeyedWorkItem<K, ElemT>> {
    private final Coder<K> keyCoder;
    private final Coder<ElemT> elemCoder;
    private final Coder<? extends BoundedWindow> windowCoder;
    private final WindowedValue.FullWindowedValueCoder<ElemT> valueCoder;

    public static <K, ElemT> SingletonKeyedWorkItemCoder<K, ElemT> of(Coder<K> keyCoder, Coder<ElemT> elemCoder, Coder<? extends BoundedWindow> windowCoder) {
        return new SingletonKeyedWorkItemCoder<K, ElemT>(keyCoder, elemCoder, windowCoder);
    }

    private SingletonKeyedWorkItemCoder(Coder<K> keyCoder, Coder<ElemT> elemCoder, Coder<? extends BoundedWindow> windowCoder) {
        this.keyCoder = keyCoder;
        this.elemCoder = elemCoder;
        this.windowCoder = windowCoder;
        this.valueCoder = WindowedValue.FullWindowedValueCoder.of(elemCoder, windowCoder);
    }

    public Coder<K> getKeyCoder() {
        return this.keyCoder;
    }

    public Coder<ElemT> getElementCoder() {
        return this.elemCoder;
    }

    public void encode(KeyedWorkItem<K, ElemT> value, OutputStream outStream) throws CoderException, IOException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    public void encode(KeyedWorkItem<K, ElemT> value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
        SingletonKeyedWorkItem cast = (SingletonKeyedWorkItem)value;
        this.keyCoder.encode(cast.key(), outStream);
        this.valueCoder.encode(cast.value(), outStream, context);
    }

    public SingletonKeyedWorkItem<K, ElemT> decode(InputStream inStream) throws CoderException, IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    public SingletonKeyedWorkItem<K, ElemT> decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
        Object key = this.keyCoder.decode(inStream);
        WindowedValue value = this.valueCoder.decode(inStream, context);
        return new SingletonKeyedWorkItem(key, value);
    }

    public List<? extends Coder<?>> getCoderArguments() {
        return ImmutableList.of(this.keyCoder, this.elemCoder, this.windowCoder);
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.keyCoder.verifyDeterministic();
        this.elemCoder.verifyDeterministic();
        this.windowCoder.verifyDeterministic();
    }

    public boolean consistentWithEquals() {
        return false;
    }
}

