/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.util.Map;
import java.util.Objects;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MonitoringInfoMetricName
extends MetricName {
    private final String urn;
    private final Map<String, String> labels;

    private MonitoringInfoMetricName(String urn, Map<String, String> labels) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)urn) ? 1 : 0) != 0, (Object)"MonitoringInfoMetricName urn must be non-empty");
        Preconditions.checkArgument((labels != null ? 1 : 0) != 0, (Object)"MonitoringInfoMetricName labels must be non-null");
        this.urn = urn;
        this.labels = ImmutableMap.copyOf(labels);
    }

    public String getNamespace() {
        String ret = this.labels.get("NAMESPACE");
        if (ret != null) {
            return ret;
        }
        ret = this.labels.get("PCOLLECTION");
        if (ret != null) {
            return ret;
        }
        ret = this.labels.get("PTRANSFORM");
        if (ret != null) {
            return ret;
        }
        return this.urn.split(":", 2)[0];
    }

    public String getName() {
        String ret = this.labels.get("NAME");
        if (ret != null) {
            return ret;
        }
        return this.urn.split(":", 2)[1];
    }

    public String getUrn() {
        return this.urn;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public static MonitoringInfoMetricName of(MetricsApi.MonitoringInfo mi) {
        return new MonitoringInfoMetricName(mi.getUrn(), mi.getLabelsMap());
    }

    public static MonitoringInfoMetricName named(String urn, Map<String, String> labels) {
        return new MonitoringInfoMetricName(urn, labels);
    }

    public int hashCode() {
        return Objects.hash(this.urn, this.labels);
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitoringInfoMetricName)) {
            return false;
        }
        MonitoringInfoMetricName other = (MonitoringInfoMetricName)((Object)o);
        return this.urn.equals(other.urn) && this.labels.equals(other.labels);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.urn.toString());
        builder.append(" ");
        builder.append(this.labels.toString());
        return builder.toString();
    }
}

