/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.ingres;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;

@DatabaseMetaPlugin(type="INGRES", typeDescription="Ingres", documentationUrl="/database/databases/ingres.html")
@GuiPlugin(id="GUI-IngresDatabaseMeta")
public class IngresDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return -1;
        }
        return -1;
    }

    public String getDriverClass() {
        return "com.ingres.jdbc.IngresDriver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        if (Utils.isEmpty((CharSequence)port)) {
            return "jdbc:ingres://" + hostname + ":II7/" + databaseName;
        }
        return "jdbc:ingres://" + hostname + ":" + port + "/" + databaseName;
    }

    public boolean isSupportsBitmapIndex() {
        return false;
    }

    public boolean isSupportsSynonyms() {
        return false;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " DROP COLUMN " + v.getName() + Const.CR;
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        Object retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = (String)retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 9: {
                retval = (String)retval + "TIMESTAMP";
                break;
            }
            case 3: {
                retval = (String)retval + "DATE";
                break;
            }
            case 4: {
                retval = (String)retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (useAutoinc) {
                        retval = (String)retval + "BIGINT PRIMARY KEY IDENTITY(0,1)";
                        break;
                    }
                    retval = (String)retval + "BIGINT PRIMARY KEY NOT NULL";
                    break;
                }
                if (precision == 0) {
                    if (length > 9) {
                        retval = (String)retval + "BIGINT";
                        break;
                    }
                    if (length > 4) {
                        retval = (String)retval + "INTEGER";
                        break;
                    }
                    if (length > 2) {
                        retval = (String)retval + "SMALLINT";
                        break;
                    }
                    retval = (String)retval + "INTEGER1";
                    break;
                }
                retval = (String)retval + "FLOAT";
                break;
            }
            case 2: {
                if (length > 0) {
                    retval = (String)retval + "VARCHAR(" + length + ")";
                    break;
                }
                retval = (String)retval + "VARCHAR(2000)";
                break;
            }
            default: {
                retval = (String)retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = (String)retval + Const.CR;
        }
        return retval;
    }

    public String getTruncateTableStatement(String tableName) {
        return "DELETE FROM " + tableName;
    }

    public boolean isSupportsGetBlob() {
        return false;
    }
}

