/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import net.ucanaccess.commands.AbstractCursorCommand;
import net.ucanaccess.commands.CompositeFeedbackAction;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.commands.IndexSelector;
import net.ucanaccess.commands.InsertCommand;
import net.ucanaccess.converters.Persist2Jet;
import net.ucanaccess.jdbc.UcanaccessSQLException;

public class DeleteCommand
extends AbstractCursorCommand {
    private String execId;
    private IndexSelector indexSelector;
    private Map<String, Object> rowPattern;
    private Table table;

    public DeleteCommand(Table _table, Map<String, Object> _rowPattern, String _execId) {
        this.indexSelector = new IndexSelector(_table);
        this.rowPattern = _rowPattern;
        this.execId = _execId;
        this.table = _table;
    }

    @Override
    public String getExecId() {
        return this.execId;
    }

    @Override
    public IndexSelector getIndexSelector() {
        return this.indexSelector;
    }

    @Override
    public Map<String, Object> getRowPattern() {
        return this.rowPattern;
    }

    @Override
    public String getTableName() {
        return this.table.getName();
    }

    @Override
    public ICommand.TYPES getType() {
        return ICommand.TYPES.DELETE;
    }

    @Override
    public IFeedbackAction persist() throws SQLException {
        try {
            Cursor cur = this.indexSelector.getCursor();
            if (cur.findNextRow(this.rowPattern)) {
                cur.deleteCurrentRow();
            }
        }
        catch (IOException e) {
            throw new UcanaccessSQLException(e);
        }
        return null;
    }

    @Override
    public CompositeFeedbackAction persistCurrentRow(Cursor cur) throws IOException {
        cur.deleteCurrentRow();
        return null;
    }

    @Override
    public IFeedbackAction rollback() throws SQLException {
        InsertCommand ic = new InsertCommand(this.table, new Persist2Jet().getValues(this.rowPattern, this.table), this.execId);
        return ic.persist();
    }
}

