/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.execprocess;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.execprocess.ExecProcessMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ExecProcessDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = ExecProcessMeta.class;
    private CCombo wProcess;
    private Button wArgumentsInFields;
    private TableView wArgumentFields;
    private Button wFailWhenNotSuccess;
    private LabelTextVar wOutputDelim;
    private LabelTextVar wResult;
    private LabelTextVar wExitValue;
    private LabelTextVar wError;
    private final ExecProcessMeta input;
    private boolean gotPreviousFields = false;

    public ExecProcessDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (ExecProcessMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        ExecProcessDialog execProcessDialog = this;
        int margin = execProcessDialog.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.GeneralTab.TabItem", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = margin;
        generalLayout.marginHeight = margin;
        wGeneralComp.setLayout((Layout)generalLayout);
        Label wlProcess = new Label(wGeneralComp, 131072);
        wlProcess.setText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.Process.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlProcess);
        FormData fdlProcess = new FormData();
        fdlProcess.left = new FormAttachment(0, 0);
        fdlProcess.right = new FormAttachment(middle, -margin);
        fdlProcess.top = new FormAttachment((Control)this.wTransformName, margin);
        wlProcess.setLayoutData((Object)fdlProcess);
        this.wProcess = new CCombo(wGeneralComp, 2056);
        this.wProcess.setEditable(true);
        PropsUi.setLook((Widget)this.wProcess);
        this.wProcess.addModifyListener(lsMod);
        FormData fdProcess = new FormData();
        fdProcess.left = new FormAttachment(middle, 0);
        fdProcess.top = new FormAttachment((Control)this.wTransformName, margin);
        fdProcess.right = new FormAttachment(100, -margin);
        this.wProcess.setLayoutData((Object)fdProcess);
        this.wProcess.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)ExecProcessDialog.this.shell.getDisplay(), 1);
                ExecProcessDialog.this.shell.setCursor(busy);
                ExecProcessDialog.this.get();
                ExecProcessDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlArgumentsInFields = new Label(wGeneralComp, 131072);
        wlArgumentsInFields.setText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.ArgumentInFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlArgumentsInFields);
        FormData fdlArgumentsInFields = new FormData();
        fdlArgumentsInFields.left = new FormAttachment(0, 0);
        fdlArgumentsInFields.top = new FormAttachment((Control)this.wProcess, margin);
        fdlArgumentsInFields.right = new FormAttachment(middle, -margin);
        wlArgumentsInFields.setLayoutData((Object)fdlArgumentsInFields);
        this.wArgumentsInFields = new Button(wGeneralComp, 32);
        this.wArgumentsInFields.setToolTipText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.ArgumentInFields.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wArgumentsInFields);
        FormData fdArgumentsInFields = new FormData();
        fdArgumentsInFields.left = new FormAttachment(middle, 0);
        fdArgumentsInFields.top = new FormAttachment((Control)wlArgumentsInFields, 0, 0x1000000);
        fdArgumentsInFields.right = new FormAttachment(100, 0);
        this.wArgumentsInFields.setLayoutData((Object)fdArgumentsInFields);
        this.wArgumentsInFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecProcessDialog.this.enableFields();
                ExecProcessDialog.this.input.setChanged();
            }
        });
        Label wlFailWhenNotSuccess = new Label(wGeneralComp, 131072);
        wlFailWhenNotSuccess.setText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.FailWhenNotSuccess.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFailWhenNotSuccess);
        FormData fdlFailWhenNotSuccess = new FormData();
        fdlFailWhenNotSuccess.left = new FormAttachment(0, 0);
        fdlFailWhenNotSuccess.top = new FormAttachment((Control)this.wArgumentsInFields, margin);
        fdlFailWhenNotSuccess.right = new FormAttachment(middle, -margin);
        wlFailWhenNotSuccess.setLayoutData((Object)fdlFailWhenNotSuccess);
        this.wFailWhenNotSuccess = new Button(wGeneralComp, 32);
        this.wFailWhenNotSuccess.setToolTipText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.FailWhenNotSuccess.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFailWhenNotSuccess);
        FormData fdFailWhenNotSuccess = new FormData();
        fdFailWhenNotSuccess.left = new FormAttachment(middle, 0);
        fdFailWhenNotSuccess.top = new FormAttachment((Control)wlFailWhenNotSuccess, 0, 0x1000000);
        fdFailWhenNotSuccess.right = new FormAttachment(100, 0);
        this.wFailWhenNotSuccess.setLayoutData((Object)fdFailWhenNotSuccess);
        this.wFailWhenNotSuccess.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecProcessDialog.this.input.setChanged();
            }
        });
        Label wlArgumentFields = new Label(wGeneralComp, 16384);
        wlArgumentFields.setText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.ArgumentFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlArgumentFields);
        FormData fdlArgumentFields = new FormData();
        fdlArgumentFields.left = new FormAttachment(0, 0);
        fdlArgumentFields.top = new FormAttachment((Control)this.wFailWhenNotSuccess, margin);
        fdlArgumentFields.right = new FormAttachment(middle, -margin);
        wlArgumentFields.setLayoutData((Object)fdlArgumentFields);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ExecProcessDialog.ArgumentField.Label", (String[])new String[0]), 2, new String[]{""}, false)};
        colinf[0].setToolTip(BaseMessages.getString(PKG, (String)"ExecProcessDialog.ArgumentField.Tooltip", (String[])new String[0]));
        this.wArgumentFields = new TableView(null, wGeneralComp, 67586, colinf, 1, lsMod, this.props);
        FormData fdArgumentFields = new FormData();
        fdArgumentFields.left = new FormAttachment(0, 0);
        fdArgumentFields.top = new FormAttachment((Control)wlArgumentFields, margin);
        fdArgumentFields.right = new FormAttachment(100, 0);
        fdArgumentFields.bottom = new FormAttachment(100, -margin);
        this.wArgumentFields.setLayoutData((Object)fdArgumentFields);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        CTabItem wOutputTab = new CTabItem(wTabFolder, 0);
        wOutputTab.setFont(GuiResource.getInstance().getFontDefault());
        wOutputTab.setText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.Output.TabItem", (String[])new String[0]));
        Composite wOutputComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wOutputComp);
        FormLayout fdOutputCompLayout = new FormLayout();
        fdOutputCompLayout.marginWidth = margin;
        fdOutputCompLayout.marginHeight = margin;
        wOutputComp.setLayout((Layout)fdOutputCompLayout);
        this.wOutputDelim = new LabelTextVar(this.variables, wOutputComp, 18436, BaseMessages.getString(PKG, (String)"ExecProcessDialog.OutputDelimiterField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecProcessDialog.OutputDelimiterField.Tooltip", (String[])new String[0]));
        this.wOutputDelim.addModifyListener(lsMod);
        FormData fdOutputDelim = new FormData();
        fdOutputDelim.left = new FormAttachment(0, 0);
        fdOutputDelim.top = new FormAttachment(0, margin);
        fdOutputDelim.right = new FormAttachment(100, 0);
        this.wOutputDelim.setLayoutData((Object)fdOutputDelim);
        this.wResult = new LabelTextVar(this.variables, wOutputComp, 18436, BaseMessages.getString(PKG, (String)"ExecProcessDialog.ResultField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecProcessDialog.ResultField.Tooltip", (String[])new String[0]));
        this.wResult.addModifyListener(lsMod);
        FormData fdResult = new FormData();
        fdResult.left = new FormAttachment(0, 0);
        fdResult.top = new FormAttachment((Control)this.wOutputDelim, margin);
        fdResult.right = new FormAttachment(100, 0);
        this.wResult.setLayoutData((Object)fdResult);
        this.wError = new LabelTextVar(this.variables, wOutputComp, 18436, BaseMessages.getString(PKG, (String)"ExecProcessDialog.ErrorField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecProcessDialog.ErrorField.Tooltip", (String[])new String[0]));
        this.wError.addModifyListener(lsMod);
        FormData fdError = new FormData();
        fdError.left = new FormAttachment(0, 0);
        fdError.top = new FormAttachment((Control)this.wResult, margin);
        fdError.right = new FormAttachment(100, 0);
        this.wError.setLayoutData((Object)fdError);
        this.wExitValue = new LabelTextVar(this.variables, wOutputComp, 18436, BaseMessages.getString(PKG, (String)"ExecProcessDialog.ExitValueField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecProcessDialog.ExitValueField.Tooltip", (String[])new String[0]));
        this.wExitValue.addModifyListener(lsMod);
        FormData fdExitValue = new FormData();
        fdExitValue.left = new FormAttachment(0, 0);
        fdExitValue.top = new FormAttachment((Control)this.wError, margin);
        fdExitValue.right = new FormAttachment(100, 0);
        this.wExitValue.setLayoutData((Object)fdExitValue);
        FormData fdOutputComp = new FormData();
        fdOutputComp.left = new FormAttachment(0, 0);
        fdOutputComp.top = new FormAttachment(0, 0);
        fdOutputComp.right = new FormAttachment(100, 0);
        fdOutputComp.bottom = new FormAttachment(100, 0);
        wOutputComp.setLayoutData((Object)fdOutputComp);
        wOutputComp.layout();
        wOutputTab.setControl((Control)wOutputComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        wTabFolder.setSelection(0);
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                this.wArgumentFields.getColumns()[0].setComboValues(r.getFieldNames());
            }
        }
        catch (HopTransformException hopTransformException) {
            // empty catch block
        }
        this.getData();
        this.enableFields();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ExecProcessDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getProcessField() != null) {
            this.wProcess.setText(this.input.getProcessField());
        }
        if (this.input.getResultFieldName() != null) {
            this.wResult.setText(this.input.getResultFieldName());
        }
        if (this.input.getErrorFieldName() != null) {
            this.wError.setText(this.input.getErrorFieldName());
        }
        if (this.input.getExitValueFieldName() != null) {
            this.wExitValue.setText(this.input.getExitValueFieldName());
        }
        if (this.input.getOutputLineDelimiter() != null) {
            this.wOutputDelim.setText(this.input.getOutputLineDelimiter());
        }
        this.wFailWhenNotSuccess.setSelection(this.input.isFailWhenNotSuccess());
        this.wArgumentsInFields.setSelection(this.input.isArgumentsInFields());
        int nrRows = this.input.getArgumentFieldNames().length;
        if (nrRows <= 0) {
            this.wArgumentFields.getTable().setItemCount(1);
        } else {
            this.wArgumentFields.getTable().setItemCount(nrRows);
            for (int i = 0; i < this.input.getArgumentFieldNames().length; ++i) {
                TableItem item = this.wArgumentFields.getTable().getItem(i);
                item.setText(1, this.input.getArgumentFieldNames()[i]);
            }
        }
        this.wArgumentFields.setRowNums();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void enableFields() {
        this.wArgumentFields.setEnabled(this.wArgumentsInFields.getSelection());
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setProcessField(this.wProcess.getText());
        this.input.setResultFieldName(this.wResult.getText());
        this.input.setErrorFieldName(this.wError.getText());
        this.input.setExitValueFieldName(this.wExitValue.getText());
        this.input.setFailWhenNotSuccess(this.wFailWhenNotSuccess.getSelection());
        this.input.setOutputLineDelimiter(this.wOutputDelim.getText());
        this.input.setArgumentsInFields(this.wArgumentsInFields.getSelection());
        String[] argumentFields = null;
        argumentFields = this.wArgumentsInFields.getSelection() ? new String[this.wArgumentFields.nrNonEmpty()] : new String[]{};
        for (int i = 0; i < argumentFields.length; ++i) {
            argumentFields[i] = this.wArgumentFields.getNonEmpty(i).getText(1);
        }
        this.input.setArgumentFieldNames(argumentFields);
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void get() {
        if (!this.gotPreviousFields) {
            try {
                String fieldvalue = this.wProcess.getText();
                this.wProcess.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wProcess.setItems(r.getFieldNames());
                }
                if (fieldvalue != null) {
                    this.wProcess.setText(fieldvalue);
                }
                this.gotPreviousFields = true;
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ExecProcessDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecProcessDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }
}

