/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class QueryableStateStream<K, V> {
    private final String queryableStateName;
    private final TypeSerializer<K> keySerializer;
    private final StateDescriptor<?, V> stateDescriptor;

    public QueryableStateStream(String queryableStateName, StateDescriptor<?, V> stateDescriptor, TypeSerializer<K> keySerializer) {
        this.queryableStateName = (String)Preconditions.checkNotNull((Object)queryableStateName, (String)"Queryable state name");
        this.stateDescriptor = (StateDescriptor)Preconditions.checkNotNull(stateDescriptor, (String)"State Descriptor");
        this.keySerializer = (TypeSerializer)Preconditions.checkNotNull(keySerializer, (String)"Key serializer");
    }

    public String getQueryableStateName() {
        return this.queryableStateName;
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public StateDescriptor<?, V> getStateDescriptor() {
        return this.stateDescriptor;
    }
}

