/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.id;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.VertexQuery;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.WrapperVertexQuery;
import com.tinkerpop.blueprints.util.wrappers.id.IdEdgeIterable;
import com.tinkerpop.blueprints.util.wrappers.id.IdElement;
import com.tinkerpop.blueprints.util.wrappers.id.IdGraph;
import com.tinkerpop.blueprints.util.wrappers.id.IdVertexIterable;

public class IdVertex
extends IdElement
implements Vertex {
    protected IdVertex(Vertex baseVertex, IdGraph idGraph) {
        super(baseVertex, idGraph, idGraph.getSupportVertexIds());
    }

    public Vertex getBaseVertex() {
        return (Vertex)this.baseElement;
    }

    @Override
    public Iterable<Edge> getEdges(Direction direction, String ... labels) {
        return new IdEdgeIterable(((Vertex)this.baseElement).getEdges(direction, labels), this.idGraph);
    }

    @Override
    public Iterable<Vertex> getVertices(Direction direction, String ... labels) {
        return new IdVertexIterable(((Vertex)this.baseElement).getVertices(direction, labels), this.idGraph);
    }

    @Override
    public VertexQuery query() {
        return new WrapperVertexQuery(((Vertex)this.baseElement).query()){

            @Override
            public Iterable<Vertex> vertices() {
                return new IdVertexIterable(this.query.vertices(), IdVertex.this.idGraph);
            }

            @Override
            public Iterable<Edge> edges() {
                return new IdEdgeIterable(this.query.edges(), IdVertex.this.idGraph);
            }
        };
    }

    @Override
    public void setProperty(String key, Object value) {
        super.setProperty(key, value);
    }

    @Override
    public Edge addEdge(String label, Vertex vertex) {
        return this.idGraph.addEdge(null, this, vertex, label);
    }

    public String toString() {
        return StringFactory.vertexString(this);
    }
}

