/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.filemetadata;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvValidationException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.StringEvaluator;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.filemetadata.FileMetadataData;
import org.apache.hop.pipeline.transforms.filemetadata.FileMetadataMeta;
import org.apache.hop.pipeline.transforms.filemetadata.util.delimiters.DelimiterDetector;
import org.apache.hop.pipeline.transforms.filemetadata.util.delimiters.DelimiterDetectorBuilder;
import org.apache.hop.pipeline.transforms.filemetadata.util.encoding.EncodingDetector;

public class FileMetadata
extends BaseTransform<FileMetadataMeta, FileMetadataData> {
    private Object[] r;
    private Charset defaultCharset = StandardCharsets.ISO_8859_1;
    private long limitRows;

    public FileMetadata(TransformMeta transformMeta, FileMetadataMeta meta, FileMetadataData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        this.r = this.getRow();
        if (this.first) {
            this.first = false;
            ((FileMetadataData)this.data).isReceivingInput = !this.getPipelineMeta().findPreviousTransforms(this.getTransformMeta()).isEmpty();
            ((FileMetadataData)this.data).outputRowMeta = ((FileMetadataData)this.data).isReceivingInput ? this.getInputRowMeta().clone() : new RowMeta();
            ((FileMetadataMeta)this.meta).getFields(((FileMetadataData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        }
        if (((FileMetadataData)this.data).isReceivingInput) {
            if (this.r == null) {
                this.setOutputDone();
                return false;
            }
            this.buildOutputRows();
            if (this.checkFeedback(this.getLinesRead())) {
                this.logBasic("LineNr " + this.getLinesRead());
            }
            return true;
        }
        this.buildOutputRows();
        this.setOutputDone();
        return false;
    }

    private void buildOutputRows() throws HopTransformException {
        int idx = ((FileMetadataData)this.data).isReceivingInput ? this.getInputRowMeta().size() : 0;
        Object[] outputRow = ((FileMetadataData)this.data).isReceivingInput ? RowDataUtil.createResizedCopy((Object[])this.r, (int)((FileMetadataData)this.data).outputRowMeta.size()) : RowDataUtil.allocateRowData((int)((FileMetadataData)this.data).outputRowMeta.size());
        String fileName = this.resolve(((FileMetadataMeta)this.meta).getFileName());
        try {
            if (!HopVfs.fileExists((String)fileName)) {
                this.putRow(((FileMetadataData)this.data).outputRowMeta, outputRow);
                return;
            }
        }
        catch (HopFileException e) {
            throw new HopTransformException(e.getMessage(), (Throwable)e);
        }
        String strLimitRows = this.resolve(((FileMetadataMeta)this.meta).getLimitRows());
        this.limitRows = strLimitRows.trim().isEmpty() ? 0L : Long.parseLong(strLimitRows);
        this.defaultCharset = Charset.forName(this.resolve(((FileMetadataMeta)this.meta).getDefaultCharset()));
        ArrayList<Character> delimiterCandidates = new ArrayList<Character>(4);
        for (FileMetadataMeta.FMCandidate fMCandidate : ((FileMetadataMeta)this.meta).getDelimiterCandidates()) {
            String candidate = this.resolve(fMCandidate.getCandidate());
            if (candidate.length() == 0) {
                this.logBasic("Warning: file metadata transform ignores empty delimiter candidate");
                continue;
            }
            if (candidate.length() > 1) {
                this.logBasic("Warning: file metadata transform ignores non-character delimiter candidate: " + candidate);
                continue;
            }
            delimiterCandidates.add(Character.valueOf(candidate.charAt(0)));
        }
        ArrayList<Character> enclosureCandidates = new ArrayList<Character>(4);
        for (FileMetadataMeta.FMCandidate enclosureCandidate : ((FileMetadataMeta)this.meta).getEnclosureCandidates()) {
            String candidate = this.resolve(enclosureCandidate.getCandidate());
            if (candidate.length() == 0) {
                this.logBasic("Warning: file metadata transform ignores empty enclosure candidate");
                continue;
            }
            if (candidate.length() > 1) {
                this.logBasic("Warning: file metadata transform ignores non-character enclosure candidate: " + candidate);
                continue;
            }
            enclosureCandidates.add(Character.valueOf(candidate.charAt(0)));
        }
        Charset charset = this.detectCharset(fileName);
        outputRow[idx++] = charset;
        DelimiterDetector.DetectionResult delimiters = this.detectDelimiters(fileName, charset, delimiterCandidates, enclosureCandidates);
        if (delimiters == null) {
            throw new HopTransformException("Could not determine a consistent format for file " + fileName);
        }
        outputRow[idx++] = delimiters.getDelimiter();
        outputRow[idx++] = delimiters.getEnclosure() == null ? "" : delimiters.getEnclosure().toString();
        outputRow[idx++] = delimiters.getDataLineFrequency() + 1L;
        outputRow[idx++] = delimiters.getBadHeaders();
        outputRow[idx++] = delimiters.getBadFooters();
        char delimiter = delimiters.getDelimiter().charValue();
        char enclosure = delimiters.getEnclosure() == null ? (char)'\u0000' : delimiters.getEnclosure().charValue();
        long dataLines = delimiters.getDataLines();
        try (BufferedReader inputReader = new BufferedReader(new InputStreamReader(HopVfs.getInputStream((String)fileName), charset));){
            for (long skipLines = delimiters.getBadHeaders(); skipLines > 0L; --skipLines) {
                inputReader.readLine();
            }
            CSVParser csvParser = new CSVParserBuilder().withSeparator(delimiter).withQuoteChar(enclosure).build();
            try (CSVReader csvReader = new CSVReaderBuilder((Reader)inputReader).withCSVParser((ICSVParser)csvParser).build();){
                int i;
                String[] firstLine = csvReader.readNext();
                --dataLines;
                StringEvaluator[] evaluators = new StringEvaluator[firstLine.length];
                for (int i3 = 0; i3 < evaluators.length; ++i3) {
                    evaluators[i3] = new StringEvaluator(true);
                }
                while (dataLines > 0L) {
                    --dataLines;
                    String[] fields = csvReader.readNext();
                    if (fields == null) break;
                    for (int i4 = 0; i4 < fields.length; ++i4) {
                        if (i4 >= evaluators.length) continue;
                        evaluators[i4].evaluateString(fields[i4]);
                    }
                }
                IValueMeta[] fields = new IValueMeta[evaluators.length];
                IValueMeta[] firstLineFields = new IValueMeta[evaluators.length];
                for (int i5 = 0; i5 < evaluators.length; ++i5) {
                    fields[i5] = evaluators[i5].getAdvicedResult().getConversionMeta();
                    evaluators[i5].evaluateString(firstLine[i5]);
                    firstLineFields[i5] = evaluators[i5].getAdvicedResult().getConversionMeta();
                }
                boolean hasHeader = false;
                boolean allStrings = true;
                for (int i2 = 0; i2 < evaluators.length; ++i2) {
                    if (fields[i2].getType() != 2) {
                        allStrings = false;
                    }
                    if (fields[i2].getType() == firstLineFields[i2].getType()) continue;
                    hasHeader = true;
                    break;
                }
                boolean bl = hasHeader = hasHeader || allStrings;
                if (hasHeader) {
                    for (int i2 = 0; i2 < evaluators.length; ++i2) {
                        fields[i2].setName(firstLine[i2].trim());
                    }
                } else {
                    fields = firstLineFields;
                    int colNum = 1;
                    for (i = 0; i < evaluators.length; ++i) {
                        fields[i].setName("field_" + colNum++);
                    }
                }
                outputRow[idx++] = hasHeader;
                int fieldIdx = idx;
                for (i = 0; i < evaluators.length; ++i) {
                    outputRow = RowDataUtil.createResizedCopy((Object[])outputRow, (int)outputRow.length);
                    idx = fieldIdx;
                    outputRow[idx++] = fields[i].getName();
                    outputRow[idx++] = fields[i].getTypeDesc();
                    outputRow[idx++] = fields[i].getLength() >= 0 ? Long.valueOf(fields[i].getLength()) : null;
                    outputRow[idx++] = fields[i].getPrecision() >= 0 ? Long.valueOf(fields[i].getPrecision()) : null;
                    outputRow[idx++] = fields[i].getConversionMask();
                    outputRow[idx++] = fields[i].getDecimalSymbol();
                    outputRow[idx] = fields[i].getGroupingSymbol();
                    this.putRow(((FileMetadataData)this.data).outputRowMeta, outputRow);
                }
            }
        }
        catch (IOException | HopFileException e) {
            this.log.logError("IO Error while reading file: " + fileName + ". Invalid charset?");
            throw new HopTransformException(e.getMessage(), e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.log.logError("Error determining field types for: " + fileName + ". Inconsistent delimiters?");
            throw new HopTransformException(e.getMessage(), (Throwable)e);
        }
        catch (CsvValidationException e) {
            this.log.logError("Error validating CSV file " + fileName, (Throwable)e);
            throw new HopTransformException(e.getMessage(), (Throwable)e);
        }
    }

    private Charset detectCharset(String fileName) {
        Charset charset;
        block9: {
            InputStream stream = HopVfs.getInputStream((String)fileName);
            try {
                charset = EncodingDetector.detectEncoding(stream, this.defaultCharset, this.limitRows * 500L);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("File not found: " + fileName, e);
                }
                catch (IOException | HopFileException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            stream.close();
        }
        return charset;
    }

    private DelimiterDetector.DetectionResult detectDelimiters(String fileName, Charset charset, ArrayList<Character> delimiterCandidates, ArrayList<Character> enclosureCandidates) {
        DelimiterDetector.DetectionResult detectionResult;
        BufferedReader f = new BufferedReader(new InputStreamReader(HopVfs.getInputStream((String)fileName), charset));
        try {
            DelimiterDetector detector = new DelimiterDetectorBuilder().withDelimiterCandidates(delimiterCandidates).withEnclosureCandidates(enclosureCandidates).withInput(f).withLogger(this.log).withRowLimit(this.limitRows).build();
            detectionResult = detector.detectDelimiters();
        }
        catch (Throwable throwable) {
            try {
                try {
                    f.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | HopFileException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        f.close();
        return detectionResult;
    }
}

