/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import org.apache.beam.runners.core.construction.resources.PipelineResources;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.FileStagingOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;

public interface SparkCommonPipelineOptions
extends PipelineOptions,
StreamingOptions,
ApplicationNameOptions,
FileStagingOptions {
    public static final String DEFAULT_MASTER_URL = "local[4]";

    @Description(value="The url of the spark master to connect to, (e.g. spark://host:port, local[4]).")
    @Default.String(value="local[4]")
    public String getSparkMaster();

    public void setSparkMaster(String var1);

    @Description(value="A checkpoint directory for streaming resilience, ignored in batch. For durability, a reliable filesystem such as HDFS/S3/GS is necessary.")
    @Default.InstanceFactory(value=TmpCheckpointDirFactory.class)
    public String getCheckpointDir();

    public void setCheckpointDir(String var1);

    @Description(value="Batch default storage level")
    @Default.String(value="MEMORY_ONLY")
    public String getStorageLevel();

    public void setStorageLevel(String var1);

    @Description(value="Enable/disable sending aggregator values to Spark's metric sinks")
    @Default.Boolean(value=true)
    public Boolean getEnableSparkMetricSinks();

    public void setEnableSparkMetricSinks(Boolean var1);

    @Internal
    public static void prepareFilesToStage(SparkCommonPipelineOptions options) {
        if (!options.getSparkMaster().matches("local\\[?\\d*]?")) {
            PipelineResources.prepareFilesForStaging((FileStagingOptions)options);
        }
    }

    public static class TmpCheckpointDirFactory
    implements DefaultValueFactory<String> {
        public String create(PipelineOptions options) {
            return "/tmp/" + options.getJobName();
        }
    }
}

