/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation.streaming;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.util.GlobalWatermarkHolder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.InputDStream;
import org.joda.time.Instant;
import scala.Option;
import scala.reflect.ClassTag;

public class TestDStream<T>
extends InputDStream<WindowedValue<T>> {
    private final Coder<WindowedValue<T>> coder;
    @Nullable
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private final transient List<TestStream.Event<T>> events;
    private int currentEventIndex = 0;
    private boolean insertEmptyBatch = false;
    private long lastValidTimeMs = 0L;
    private Instant lastWatermark = Instant.EPOCH;

    public TestDStream(TestStream<T> test, StreamingContext ssc) {
        super(ssc, TestDStream.classTag());
        this.coder = WindowedValue.getFullCoder((Coder)test.getValueCoder(), (Coder)GlobalWindow.Coder.INSTANCE);
        this.events = test.getEvents();
    }

    public Option<RDD<WindowedValue<T>>> compute(Time validTime) {
        TestStream.Event<T> event;
        TestStream.Event<T> event2 = event = this.insertEmptyBatch ? null : this.nextEvent();
        if (event == null) {
            this.insertEmptyBatch = false;
            this.waitForLastBatch(validTime);
            return Option.apply(this.emptyRDD());
        }
        if (event instanceof TestStream.ElementEvent) {
            this.waitForLastBatch(validTime);
            return Option.apply(this.buildRdd((TestStream.ElementEvent)event));
        }
        if (event instanceof TestStream.WatermarkEvent) {
            this.waitForLastBatch(validTime);
            this.addWatermark(validTime, (TestStream.WatermarkEvent)event);
            this.insertEmptyBatch = true;
            return Option.apply(this.emptyRDD());
        }
        if (event instanceof TestStream.ProcessingTimeEvent) {
            throw new UnsupportedOperationException("Advancing Processing time is not supported by the Spark Runner.");
        }
        throw new IllegalStateException("Unknown event type " + event);
    }

    private void waitForLastBatch(Time validTime) {
        while (GlobalWatermarkHolder.getLastWatermarkedBatchTime() < this.lastValidTimeMs) {
            Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        this.lastValidTimeMs = validTime.milliseconds();
    }

    @Nullable
    private TestStream.Event<T> nextEvent() {
        List events = (List)Preconditions.checkStateNotNull(this.events);
        return events.size() > this.currentEventIndex ? (TestStream.Event)events.get(this.currentEventIndex++) : null;
    }

    private void addWatermark(Time time, TestStream.WatermarkEvent<T> event) {
        GlobalWatermarkHolder.SparkWatermarks watermarks = new GlobalWatermarkHolder.SparkWatermarks(this.lastWatermark, event.getWatermark(), new Instant(time.milliseconds()));
        this.lastWatermark = event.getWatermark();
        GlobalWatermarkHolder.add(this.id(), watermarks);
    }

    public void start() {
    }

    public void stop() {
    }

    private RDD<WindowedValue<T>> emptyRDD() {
        return this.ssc().sparkContext().emptyRDD(TestDStream.classTag());
    }

    private RDD<WindowedValue<T>> buildRdd(TestStream.ElementEvent<T> event) {
        ArrayList<byte[]> binaryData = new ArrayList<byte[]>();
        for (TimestampedValue elem : event.getElements()) {
            WindowedValue wv = WindowedValue.timestampedValueInGlobalWindow((Object)elem.getValue(), (Instant)elem.getTimestamp());
            binaryData.add(CoderHelpers.toByteArray(wv, this.coder));
        }
        return new JavaSparkContext(this.ssc().sparkContext()).parallelize(binaryData).map(CoderHelpers.fromByteFunction(this.coder)).rdd();
    }

    private static <T> ClassTag<WindowedValue<T>> classTag() {
        return JavaSparkContext$.MODULE$.fakeClassTag();
    }
}

