/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.EnumUtils;
import org.apache.hive.service.auth.HiveAuthConstants;

public class AuthType {
    static final Set<HiveAuthConstants.AuthTypes> PASSWORD_BASED_TYPES = new HashSet<HiveAuthConstants.AuthTypes>(Arrays.asList(HiveAuthConstants.AuthTypes.LDAP, HiveAuthConstants.AuthTypes.CUSTOM, HiveAuthConstants.AuthTypes.PAM));
    private final BitSet typeBits = new BitSet();

    public AuthType(String authTypes) throws Exception {
        this.parseTypes(authTypes);
        this.verifyTypes(authTypes);
    }

    private void parseTypes(String authTypes) throws Exception {
        String[] types;
        for (String type : types = authTypes.split(",")) {
            if (!EnumUtils.isValidEnumIgnoreCase(HiveAuthConstants.AuthTypes.class, (String)type)) {
                throw new Exception(type + " is not a valid authentication type.");
            }
            this.typeBits.set(((HiveAuthConstants.AuthTypes)EnumUtils.getEnumIgnoreCase(HiveAuthConstants.AuthTypes.class, (String)type)).ordinal());
        }
    }

    private void verifyTypes(String authTypes) throws Exception {
        if (this.typeBits.cardinality() == 1) {
            return;
        }
        if (!(!this.typeBits.get(HiveAuthConstants.AuthTypes.SAML.ordinal()) || this.typeBits.get(HiveAuthConstants.AuthTypes.NOSASL.ordinal()) || this.typeBits.get(HiveAuthConstants.AuthTypes.KERBEROS.ordinal()) || this.typeBits.get(HiveAuthConstants.AuthTypes.NONE.ordinal()) || this.areAnyEnabled(PASSWORD_BASED_TYPES) && !this.isExactlyOneEnabled(PASSWORD_BASED_TYPES))) {
            return;
        }
        throw new Exception("The authentication types have conflicts: " + authTypes);
    }

    private boolean isExactlyOneEnabled(Collection<HiveAuthConstants.AuthTypes> types) {
        boolean areAnyEnabled = false;
        boolean areTwoEnabled = false;
        Iterator<HiveAuthConstants.AuthTypes> it = types.iterator();
        while (!areTwoEnabled && it.hasNext()) {
            boolean isCurrentTypeEnabled = this.isEnabled(it.next());
            areTwoEnabled = areAnyEnabled && isCurrentTypeEnabled;
            areAnyEnabled |= isCurrentTypeEnabled;
        }
        return areAnyEnabled && !areTwoEnabled;
    }

    private boolean areAnyEnabled(Collection<HiveAuthConstants.AuthTypes> types) {
        boolean areAnyEnabled = false;
        Iterator<HiveAuthConstants.AuthTypes> it = types.iterator();
        while (!areAnyEnabled && it.hasNext()) {
            areAnyEnabled = this.isEnabled(it.next());
        }
        return areAnyEnabled;
    }

    public boolean isEnabled(HiveAuthConstants.AuthTypes type) {
        return this.typeBits.get(type.ordinal());
    }

    public String getPasswordBasedAuthStr() {
        if (this.isEnabled(HiveAuthConstants.AuthTypes.NOSASL)) {
            return HiveAuthConstants.AuthTypes.NOSASL.getAuthName();
        }
        if (this.isEnabled(HiveAuthConstants.AuthTypes.NONE)) {
            return HiveAuthConstants.AuthTypes.NONE.getAuthName();
        }
        for (HiveAuthConstants.AuthTypes type : PASSWORD_BASED_TYPES) {
            if (!this.isEnabled(type)) continue;
            return type.getAuthName();
        }
        return "";
    }
}

