/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.saml;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.saml.HiveSaml2Client;
import org.apache.hive.service.auth.saml.HiveSamlAuthTokenGenerator;
import org.apache.hive.service.auth.saml.HiveSamlRelayStateStore;
import org.apache.hive.service.auth.saml.HiveSamlUtils;
import org.apache.hive.service.auth.saml.HttpSamlAuthenticationException;
import org.apache.hive.service.auth.saml.HttpSamlNoGroupsMatchedException;
import org.apache.hive.service.auth.saml.ISAMLAuthTokenGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSamlHttpServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HiveSamlHttpServlet.class);
    private final HiveConf conf;
    private final ISAMLAuthTokenGenerator tokenGenerator;

    public HiveSamlHttpServlet(HiveConf conf) {
        this.conf = (HiveConf)Preconditions.checkNotNull((Object)conf);
        this.tokenGenerator = HiveSamlAuthTokenGenerator.get(conf);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        String nameId;
        int port;
        String relayState;
        try {
            relayState = HiveSamlRelayStateStore.get().getRelayStateInfo(request, response);
            port = HiveSamlRelayStateStore.get().getRelayStateInfo(relayState).getPort();
        }
        catch (HttpSamlAuthenticationException e) {
            LOG.error("Invalid relay state", (Throwable)e);
            response.setStatus(401);
            return;
        }
        try {
            LOG.info("RelayState = {}. Driver side port on loopback address is {}", (Object)relayState, (Object)port);
            nameId = HiveSaml2Client.get(this.conf).validate(request, response);
        }
        catch (HttpSamlAuthenticationException e) {
            if (e instanceof HttpSamlNoGroupsMatchedException) {
                LOG.error("Could not authenticate user since the groups didn't match", (Throwable)e);
            } else {
                LOG.error("SAML response could not be validated", (Throwable)e);
            }
            this.generateFormData(response, HiveSamlUtils.getLoopBackAddress(port), null, false, "SAML assertion could not be validated. Check server logs for more details.");
            return;
        }
        Preconditions.checkState((nameId != null ? 1 : 0) != 0);
        LOG.info("Successfully validated saml response for user {}. Forwarding the token to port {}", (Object)nameId, (Object)port);
        this.generateFormData(response, HiveSamlUtils.getLoopBackAddress(port), this.tokenGenerator.get(nameId, relayState), true, "");
    }

    private void generateFormData(HttpServletResponse response, String url, String token, boolean success, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<body onload='document.forms[\"form\"].submit()'>");
        sb.append(String.format("<form name='form' action='%s' method='POST'>", url));
        sb.append(String.format("<input type='hidden' name='%s' value='%s'>", "token", token));
        sb.append(String.format("<input type='hidden' name='%s' value='%s'>", "status", success));
        sb.append(String.format("<input type='hidden' name='%s' value='%s'>", "message", msg));
        sb.append("</form>");
        sb.append("</body>");
        sb.append("</html>");
        response.setContentType("text/html");
        try {
            response.getWriter().write(sb.toString());
            response.getWriter().flush();
        }
        catch (IOException e) {
            LOG.error("Could not generate the form data for sending a response to url " + url, (Throwable)e);
            response.setStatus(500);
        }
    }
}

